/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.sql.dml;

import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.dml.SqlLogicExpression;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.repository.builder.BuilderException;
import cn.featherfly.common.repository.builder.BuilderExceptionCode;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.ParamedExpression;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractSqlConditionExpression<L>
implements SqlBuilder,
ParamedExpression {
    private List<Expression> conditions = new ArrayList<Expression>();
    protected L parent;
    protected Dialect dialect;
    private Expression previousCondition;
    private boolean ignoreEmpty = true;

    public AbstractSqlConditionExpression(Dialect dialect) {
        this(dialect, null);
    }

    protected AbstractSqlConditionExpression(Dialect dialect, L parent) {
        this.dialect = dialect;
        this.parent = parent;
    }

    public String build() {
        Expression last;
        StringBuilder result = new StringBuilder();
        if (this.conditions.size() > 0 && (last = this.conditions.get(this.conditions.size() - 1)) instanceof SqlLogicExpression) {
            throw new BuilderException(BuilderExceptionCode.createNoConditionBehindCode((String)((SqlLogicExpression)last).getLogicOperator().name()));
        }
        ArrayList<String> availableConditions = new ArrayList<String>();
        ArrayList<Expression> availableExpressions = new ArrayList<Expression>();
        for (Expression expression : this.conditions) {
            Expression pre;
            String condition = expression.expression();
            if (Strings.isNotBlank((String)condition)) {
                availableConditions.add(condition);
                availableExpressions.add(expression);
                continue;
            }
            if (availableExpressions.size() <= 0 || !((pre = (Expression)availableExpressions.get(availableExpressions.size() - 1)) instanceof SqlLogicExpression)) continue;
            availableExpressions.remove(availableExpressions.size() - 1);
            availableConditions.remove(availableConditions.size() - 1);
        }
        if (availableExpressions.size() > 0) {
            if (availableExpressions.get(0) instanceof SqlLogicExpression) {
                availableExpressions.remove(0);
                availableConditions.remove(0);
            }
            if (availableExpressions.get(availableExpressions.size() - 1) instanceof SqlLogicExpression) {
                availableExpressions.remove(availableExpressions.size() - 1);
                availableConditions.remove(availableConditions.size() - 1);
            }
        }
        for (String condition : availableConditions) {
            BuilderUtils.link((StringBuilder)result, (String)condition);
        }
        if (result.length() > 0 && this.parent != null) {
            return " ( " + result.toString() + " ) ";
        }
        return result.toString();
    }

    public String expression() {
        return this.build();
    }

    public Object getParam() {
        return this.getParams();
    }

    public List<Object> getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Expression condition : this.conditions) {
            Object param;
            if (!(condition instanceof ParamedExpression) || !Lang.isNotEmpty((Object)(param = ((ParamedExpression)condition).getParam()))) continue;
            if (param instanceof Collection) {
                params.addAll((Collection)param);
                continue;
            }
            if (param.getClass().isArray()) {
                int length = Array.getLength(param);
                for (int i = 0; i < length; ++i) {
                    params.add(Array.get(param, i));
                }
                continue;
            }
            params.add(param);
        }
        return params;
    }

    public String toString() {
        return this.build();
    }

    protected <T, R> String getPropertyName(SerializableFunction<T, R> name) {
        return LambdaUtils.getLambdaPropertyName(name);
    }

    protected Object addCondition(Expression condition) {
        if (this.previousCondition != null && this.previousCondition.getClass().isInstance(condition)) {
            throw new BuilderException(BuilderExceptionCode.createNextToSameConditionCode((String)condition.getClass().getName()));
        }
        this.previousCondition = condition;
        this.conditions.add(condition);
        return this;
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }

    public List<Expression> getConditions() {
        return this.conditions;
    }
}

