/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractOperate;
import java.sql.ResultSet;

public abstract class AbstractQueryOperate<T>
extends AbstractOperate<T> {
    private String selectSql;

    public AbstractQueryOperate(Jdbc jdbc, ClassMapping<T> classMapping) {
        super(jdbc, classMapping);
    }

    public AbstractQueryOperate(Jdbc jdbc, ClassMapping<T> classMapping, String dataBase) {
        super(jdbc, classMapping, dataBase);
    }

    public AbstractQueryOperate(Jdbc jdbc, ClassMapping<T> classMapping, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, databaseMetadata);
    }

    protected T mapRow(cn.featherfly.common.repository.mapping.ResultSet rs, int rowNumber) {
        Object mappedObject = BeanUtils.instantiateClass((Class)this.classMapping.getType());
        int index = 1;
        for (PropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            if (propertyMapping.getPropertyMappings().isEmpty()) {
                Object value = this.getColumnValue(rs, index, propertyMapping.getPropertyType());
                index = this.setProperty(rowNumber, mappedObject, index, propertyMapping, value);
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                Object value = this.getColumnValue(rs, index, subPropertyMapping.getPropertyType());
                index = this.setProperty(rowNumber, mappedObject, index, subPropertyMapping, value);
            }
        }
        return (T)mappedObject;
    }

    private int setProperty(int rowNumber, T mappedObject, int index, PropertyMapping propertyMapping, Object value) {
        String propertyName = ClassMappingUtils.getPropertyAliasName((PropertyMapping)propertyMapping);
        if (this.logger.isDebugEnabled() && rowNumber == 0) {
            this.logger.debug("Mapping column '{}' to property '{}' of type {}", new Object[]{propertyMapping.getRepositoryFieldName(), propertyName, propertyMapping.getPropertyType()});
        }
        BeanUtils.setProperty(mappedObject, (String)propertyName, (Object)value);
        return ++index;
    }

    protected T mapRow(ResultSet rs, int rowNumber) {
        Object mappedObject = BeanUtils.instantiateClass((Class)this.classMapping.getType());
        int index = 1;
        for (PropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            Object value = this.getColumnValue(rs, index, propertyMapping.getPropertyType());
            if (this.logger.isDebugEnabled() && rowNumber == 0) {
                this.logger.debug("Mapping column '{}' to property '{}' of type {}", new Object[]{propertyMapping.getRepositoryFieldName(), propertyMapping.getPropertyName(), propertyMapping.getPropertyType()});
            }
            BeanUtils.setProperty((Object)mappedObject, (String)propertyMapping.getPropertyName(), (Object)value);
            ++index;
        }
        return (T)mappedObject;
    }

    @Override
    protected void initSql() {
        this.initSelectSql();
        StringBuilder getSql = new StringBuilder();
        getSql.append(this.getSelectSql());
        String condition = this.initCondition();
        if (Lang.isNotEmpty((String)condition)) {
            getSql.append(" ").append(this.jdbc.getDialect().getKeywords().where()).append(" ").append(condition);
        }
        this.sql = getSql.toString();
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    protected abstract String initCondition();

    private Object getColumnValue(ResultSet rs, int index, Class<?> propertyType) {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index, propertyType);
    }

    private Object getColumnValue(cn.featherfly.common.repository.mapping.ResultSet rs, int index, Class<?> propertyType) {
        return JdbcUtils.getResultSetValue((ResultSet)((SqlResultSet)rs).getResultSet(), (int)index, propertyType);
    }

    private void initSelectSql() {
        this.selectSql = ClassMappingUtils.getSelectSql((ClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
    }

    public String getSelectSql() {
        return this.selectSql;
    }
}

