/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.builder.dml.SqlSortBuilder;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.RowMapper;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.hammer.dsl.query.QuerySortExpression;
import cn.featherfly.hammer.dsl.query.RepositoryQueryConditionGroupExpression;
import cn.featherfly.hammer.dsl.query.RepositoryQueryConditionGroupLogicExpression;
import cn.featherfly.hammer.expression.query.QueryLimitExecutor;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.sql.dml.AbstractRepositorySqlConditionGroupExpression;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RepositorySqlQueryConditionGroupExpression
extends AbstractRepositorySqlConditionGroupExpression<RepositoryQueryConditionGroupExpression, RepositoryQueryConditionGroupLogicExpression>
implements RepositoryQueryConditionGroupExpression,
RepositoryQueryConditionGroupLogicExpression,
QuerySortExpression {
    private SqlSortBuilder sortBuilder;
    private Limit limit;
    protected Jdbc jdbc;

    public RepositorySqlQueryConditionGroupExpression(Jdbc jdbc, MappingFactory factory, AliasManager aliasManager) {
        this(jdbc, factory, aliasManager, null);
    }

    public RepositorySqlQueryConditionGroupExpression(Jdbc jdbc, MappingFactory factory, AliasManager aliasManager, String queryAlias) {
        this(jdbc, factory, aliasManager, queryAlias, null);
    }

    public RepositorySqlQueryConditionGroupExpression(Jdbc jdbc, MappingFactory factory, AliasManager aliasManager, String queryAlias, ClassMapping<?> classMapping) {
        this(jdbc, factory, aliasManager, null, queryAlias, classMapping);
    }

    RepositorySqlQueryConditionGroupExpression(Jdbc jdbc, MappingFactory factory, AliasManager aliasManager, RepositoryQueryConditionGroupLogicExpression parent, String queryAlias, ClassMapping<?> classMapping) {
        super(jdbc.getDialect(), factory, aliasManager, parent, queryAlias, classMapping);
        this.sortBuilder = new SqlSortBuilder(this.dialect);
        this.jdbc = jdbc;
    }

    @Override
    protected RepositoryQueryConditionGroupExpression createGroup(RepositoryQueryConditionGroupLogicExpression parent, String queryAlias) {
        return new RepositorySqlQueryConditionGroupExpression(this.jdbc, this.factory, this.aliasManager, parent, queryAlias, this.classMapping);
    }

    @Override
    public String build() {
        String condition = super.build();
        if (this.parent == null) {
            if (Lang.isNotEmpty((String)condition)) {
                return this.dialect.getKeywords().where() + " " + super.build() + " " + this.sortBuilder.build();
            }
            return super.build() + " " + this.sortBuilder.build();
        }
        return super.build();
    }

    public QueryLimitExecutor limit(Integer limit) {
        return this.limit(0, limit);
    }

    public QueryLimitExecutor limit(Integer offset, Integer limit) {
        return this.limit(new Limit(offset, limit));
    }

    public QueryLimitExecutor limit(Page page) {
        return this.limit(new Limit(page));
    }

    private QueryLimitExecutor limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public List<Map<String, Object>> list() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
        }
        return this.jdbc.query(sql, params);
    }

    public <E> List<E> list(Class<E> type) {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
        }
        return this.jdbc.query(sql, params, type);
    }

    public <E> List<E> list(RowMapper<E> rowMapper) {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
        }
        return this.jdbc.query(sql, params, rowMapper);
    }

    public PaginationResults<Map<String, Object>> pagination() {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            List<Map<String, Object>> list = this.jdbc.query(this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue()), this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue()));
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List<Map<String, Object>> list = this.jdbc.query(sql, params);
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public <E> PaginationResults<E> pagination(Class<E> type) {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            List<E> list = this.jdbc.query(this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue()), this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue()), type);
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List<E> list = this.jdbc.query(sql, params, type);
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public <E> PaginationResults<E> pagination(RowMapper<E> rowMapper) {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            List<E> list = this.jdbc.query(this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue()), this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue()), rowMapper);
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List<E> list = this.jdbc.query(sql, params, rowMapper);
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public Map<String, Object> single() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
        }
        return this.jdbc.querySingle(sql, params);
    }

    public <E> E single(Class<E> type) {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset().intValue(), this.limit.getLimit().intValue());
        }
        return this.jdbc.querySingle(sql, params, type);
    }

    public <E> E single(RowMapper<E> rowMapper) {
        return this.jdbc.querySingle(this.getRoot().expression(), this.getRoot().getParams().toArray(), rowMapper);
    }

    public String string() {
        return this.jdbc.queryString(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public Integer integer() {
        return this.jdbc.queryInt(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public Long longInt() {
        return this.jdbc.queryLong(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public BigDecimal decimal() {
        return this.jdbc.queryBigDecimal(this.getRoot().expression(), this.getRoot().getParams().toArray());
    }

    public <N extends Number> N number(Class<N> type) {
        return (N)((Number)this.jdbc.queryValue(this.getRoot().expression(), this.getRoot().getParams().toArray(), type));
    }

    public Long count() {
        throw new UnsupportedException();
    }

    public QuerySortExpression sort() {
        return this;
    }

    public QuerySortExpression asc(String ... names) {
        ((RepositorySqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.asc(ClassMappingUtils.getColumnNames((ClassMapping)this.classMapping, (String[])names));
        return this;
    }

    public QuerySortExpression asc(List<String> names) {
        ((RepositorySqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.asc(ClassMappingUtils.getColumnNames((ClassMapping)this.classMapping, names));
        return this;
    }

    public <T, R> QuerySortExpression asc(SerializableFunction<T, R> name) {
        return this.asc(this.getPropertyName(name));
    }

    public <T, R> QuerySortExpression asc(SerializableFunction<T, R> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.asc(nameArray);
    }

    public QuerySortExpression desc(String ... names) {
        ((RepositorySqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.desc(ClassMappingUtils.getColumnNames((ClassMapping)this.classMapping, (String[])names));
        return this;
    }

    public QuerySortExpression desc(List<String> names) {
        ((RepositorySqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.desc(ClassMappingUtils.getColumnNames((ClassMapping)this.classMapping, names));
        return this;
    }

    public <T, R> QuerySortExpression desc(SerializableFunction<T, R> name) {
        return this.desc(this.getPropertyName(name));
    }

    public <T, R> QuerySortExpression desc(SerializableFunction<T, R> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.desc(nameArray);
    }
}

