/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.config;

import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.dialect.Dialects;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadataManager;
import cn.featherfly.constant.annotation.Constant;
import cn.featherfly.constant.annotation.ConstantClass;
import cn.featherfly.hammer.config.HammerConstant;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SpringJdbcTemplateImpl;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateEngine;
import javax.sql.DataSource;

@ConstantClass(value="HammerSqlDb\u521d\u59cb\u5316\u914d\u7f6e")
public class SqlDbConstant
extends HammerConstant {
    @Constant(value="database dataSource")
    private DataSource dataSource;
    @Constant(value="database dialect")
    private Dialect dialect = Dialects.MYSQL;
    @Constant(value="database metadata")
    private DatabaseMetadata metadata;
    @Constant(value="object mapping factory")
    private JdbcMappingFactory mappingFactory;
    @Constant(value="jdbc operator")
    private Jdbc jdbc;
    @Constant(value="template processor")
    private SqlDbTemplateEngine templateEngine;

    private SqlDbConstant() {
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseMetadata getMetadata() {
        if (this.metadata == null) {
            SqlDbConstant sqlDbConstant = this;
            synchronized (sqlDbConstant) {
                if (this.metadata == null && this.dataSource != null) {
                    this.metadata = DatabaseMetadataManager.getDefaultManager().create(this.dataSource);
                }
            }
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcMappingFactory getMappingFactory() {
        if (this.mappingFactory == null) {
            SqlDbConstant sqlDbConstant = this;
            synchronized (sqlDbConstant) {
                if (this.mappingFactory == null && this.getMetadata() != null) {
                    this.mappingFactory = new JdbcMappingFactory(this.getMetadata(), this.getDialect());
                }
            }
        }
        return this.mappingFactory;
    }

    public SqlDbTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jdbc getJdbc() {
        if (this.jdbc == null) {
            SqlDbConstant sqlDbConstant = this;
            synchronized (sqlDbConstant) {
                if (this.jdbc == null && this.getDataSource() != null) {
                    this.jdbc = new SpringJdbcTemplateImpl(this.getDataSource(), this.getDialect());
                }
            }
        }
        return this.jdbc;
    }
}

