/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.sql.dml.builder;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.hammer.dml.builder.BuilderException;
import cn.featherfly.hammer.dml.builder.ConditionBuildUtils;
import cn.featherfly.hammer.dml.builder.ConditionBuilder;
import cn.featherfly.hammer.dml.builder.ConditionGroup;
import cn.featherfly.hammer.dml.builder.Expression;
import cn.featherfly.hammer.dml.builder.ExpressionBuilder;
import cn.featherfly.hammer.dml.builder.LogicBuilder;
import cn.featherfly.hammer.dml.builder.ParamedExpression;
import cn.featherfly.hammer.dml.builder.SortBuilder;
import cn.featherfly.hammer.operator.LogicOperator;
import cn.featherfly.hammer.operator.QueryOperator;
import cn.featherfly.hammer.sqldb.sql.dialect.Dialect;
import cn.featherfly.hammer.sqldb.sql.dml.builder.SqlConditionBuilder;
import cn.featherfly.hammer.sqldb.sql.dml.builder.SqlConditionExpression;
import cn.featherfly.hammer.sqldb.sql.dml.builder.SqlLogicExpression;
import cn.featherfly.hammer.sqldb.sql.dml.builder.SqlSortBuilder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SqlConditionGroup
implements ConditionGroup,
SqlConditionBuilder {
    private List<Expression> conditions = new ArrayList<Expression>();
    private Dialect dialect;
    private SqlConditionGroup parent;
    private SqlSortBuilder sort;
    private Expression previousCondition;
    private String queryAlias;
    private boolean ignoreEmpty = true;

    public SqlConditionGroup(Dialect dialect, SqlSortBuilder sort) {
        this(dialect, null, sort);
    }

    public SqlConditionGroup(Dialect dialect, String queryAlias, SqlSortBuilder sort) {
        this(dialect, null, sort, queryAlias);
    }

    SqlConditionGroup(Dialect dialect, SqlConditionGroup parent, SqlSortBuilder sort, String queryAlias) {
        this.dialect = dialect;
        this.sort = sort;
        this.parent = parent;
        this.queryAlias = queryAlias;
    }

    public ExpressionBuilder and() {
        this.addCondition((Expression)new SqlLogicExpression(LogicOperator.AND));
        return this;
    }

    public ExpressionBuilder or() {
        this.addCondition((Expression)new SqlLogicExpression(LogicOperator.OR));
        return this;
    }

    public LogicBuilder lt(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.LT, this.queryAlias));
        return this;
    }

    public LogicBuilder le(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.LE, this.queryAlias));
        return this;
    }

    public LogicBuilder eq(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.EQ, this.queryAlias));
        return this;
    }

    public LogicBuilder ne(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.NE, this.queryAlias));
        return this;
    }

    public LogicBuilder ge(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.GE, this.queryAlias));
        return this;
    }

    public LogicBuilder gt(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.GT, this.queryAlias));
        return this;
    }

    public LogicBuilder sw(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.SW, this.queryAlias));
        return this;
    }

    public LogicBuilder co(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.CO, this.queryAlias));
        return this;
    }

    public LogicBuilder ew(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.EW, this.queryAlias));
        return this;
    }

    public LogicBuilder in(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.IN, this.queryAlias));
        return this;
    }

    public LogicBuilder nin(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.NIN, this.queryAlias));
        return this;
    }

    public LogicBuilder isn(String name) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, null, QueryOperator.ISN, this.queryAlias));
        return this;
    }

    public LogicBuilder inn(String name) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, null, QueryOperator.INN, this.queryAlias));
        return this;
    }

    public ExpressionBuilder group() {
        SqlConditionGroup group = new SqlConditionGroup(this.dialect, this, this.sort, this.queryAlias);
        this.addCondition((Expression)group);
        return group;
    }

    public LogicBuilder parent() {
        return this.parent;
    }

    public SortBuilder sort() {
        return this.sort;
    }

    public String build() {
        Expression last;
        StringBuilder result = new StringBuilder();
        if (this.conditions.size() > 0 && (last = this.conditions.get(this.conditions.size() - 1)) instanceof SqlLogicExpression) {
            throw new BuilderException(((SqlLogicExpression)last).getLogicOperator() + " \u540e\u6ca1\u6709\u8ddf\u6761\u4ef6\u8868\u8fbe\u5f0f");
        }
        ArrayList<String> availableConditions = new ArrayList<String>();
        ArrayList<Expression> availableExpressions = new ArrayList<Expression>();
        for (Expression expression : this.conditions) {
            Expression pre;
            String condition = expression.build();
            if (StringUtils.isNotBlank((String)condition)) {
                availableConditions.add(condition);
                availableExpressions.add(expression);
                continue;
            }
            if (availableExpressions.size() <= 0 || !((pre = (Expression)availableExpressions.get(availableExpressions.size() - 1)) instanceof SqlLogicExpression)) continue;
            availableExpressions.remove(availableExpressions.size() - 1);
            availableConditions.remove(availableConditions.size() - 1);
        }
        if (availableExpressions.size() > 0 && availableExpressions.get(0) instanceof SqlLogicExpression) {
            availableExpressions.remove(0);
            availableConditions.remove(0);
        }
        for (String condition : availableConditions) {
            ConditionBuildUtils.appendCondition((StringBuilder)result, (String)condition);
        }
        if (result.length() > 0 && this.parent != null) {
            return " ( " + result.toString() + " ) ";
        }
        return result.toString();
    }

    public Object getParamValue() {
        return this.getParamValues();
    }

    public List<Object> getParamValues() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Expression condition : this.conditions) {
            Object param;
            if (!(condition instanceof ParamedExpression) || !LangUtils.isNotEmpty((Object)(param = ((ParamedExpression)condition).getParamValue()))) continue;
            if (param instanceof Collection) {
                params.addAll((Collection)param);
                continue;
            }
            if (param.getClass().isArray()) {
                int length = Array.getLength(param);
                for (int i = 0; i < length; ++i) {
                    params.add(Array.get(param, i));
                }
                continue;
            }
            params.add(param);
        }
        return params;
    }

    private void addCondition(Expression condition) {
        if (this.previousCondition != null && this.previousCondition.getClass().isInstance(condition)) {
            throw new BuilderException("\u8bed\u6cd5\u9519\u8bef\uff0c\u8fde\u7eed\u76f8\u540c\u7c7b\u578b\u7684\u8868\u8fbe\u5f0f\uff1a" + condition.getClass().getName());
        }
        this.previousCondition = condition;
        this.conditions.add(condition);
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }

    public List<Expression> getConditions() {
        return this.conditions;
    }

    public String getQueryAlias() {
        return this.queryAlias;
    }

    public void setQueryAlias(String queryAlias) {
        this.queryAlias = queryAlias;
        this.sort.setTableAlias(queryAlias);
    }

    @Override
    public ConditionBuilder where() {
        return this;
    }
}

