/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.sql.dml.builder;

import cn.featherfly.hammer.dml.builder.Builder;
import cn.featherfly.hammer.operator.AggregateFunction;
import cn.featherfly.hammer.sqldb.sql.dialect.Dialect;
import cn.featherfly.hammer.sqldb.sql.dml.builder.SqlConditionGroup;
import cn.featherfly.hammer.sqldb.sql.dml.builder.basic.SqlSelectBasicBuilder;
import java.util.Map;

public abstract class AbstractSqlSelectBuilder
implements Builder {
    private SqlSelectBasicBuilder selectBuilder;
    protected SqlConditionGroup conditionBuilder;

    public AbstractSqlSelectBuilder(Dialect dialect, SqlConditionGroup conditionBuilder) {
        this(dialect, null, null, conditionBuilder);
    }

    public AbstractSqlSelectBuilder(Dialect dialect, String tableName, SqlConditionGroup conditionBuilder) {
        this(dialect, tableName, null, conditionBuilder);
    }

    public AbstractSqlSelectBuilder(Dialect dialect, String tableName, String alias, SqlConditionGroup conditionBuilder) {
        this.conditionBuilder = conditionBuilder;
        this.selectBuilder = new SqlSelectBasicBuilder(dialect, tableName, alias);
    }

    protected void addSelectColumn(String columnName, AggregateFunction function) {
        this.selectBuilder.addSelectColumn(columnName, function);
    }

    protected void addSelectColumn(String columnName, String asName) {
        this.selectBuilder.addSelectColumn(columnName, asName);
    }

    protected void addSelectColumn(String columnNames, AggregateFunction function, String asName) {
        this.selectBuilder.addSelectColumn(columnNames, function, asName);
    }

    protected void addSelectColumn(Map<String, String> columnNames) {
        columnNames.forEach((columnName, asName) -> this.selectBuilder.addSelectColumn((String)columnName, (String)asName));
    }

    public String getTableAlias() {
        return this.selectBuilder.getTableAlias();
    }

    public void setTableAlias(String tableAlias) {
        this.selectBuilder.setTableAlias(tableAlias);
    }

    public String getTableName() {
        return this.selectBuilder.getTableName();
    }

    public void setTableName(String tableName) {
        this.selectBuilder.setTableName(tableName);
    }

    public boolean isBuildWithFrom() {
        return this.selectBuilder.isBuildWithFrom();
    }

    public void setBuildWithFrom(boolean buildWithFrom) {
        this.selectBuilder.setBuildWithFrom(buildWithFrom);
    }

    public String build() {
        return this.selectBuilder.build();
    }
}

