/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.sql.dml;

import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.hammer.dml.builder.BuilderException;
import cn.featherfly.hammer.dml.builder.ConditionBuildUtils;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.ParamedExpression;
import cn.featherfly.hammer.sqldb.sql.dialect.Dialect;
import cn.featherfly.hammer.sqldb.sql.dml.SqlBuilder;
import cn.featherfly.hammer.sqldb.sql.dml.builder.SqlLogicExpression;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractSqlConditionExpression<L>
implements SqlBuilder,
ParamedExpression {
    private List<Expression> conditions = new ArrayList<Expression>();
    protected L parent;
    protected Dialect dialect;
    private Expression previousCondition;
    private boolean ignoreEmpty = true;

    public AbstractSqlConditionExpression(Dialect dialect) {
        this(dialect, null);
    }

    protected AbstractSqlConditionExpression(Dialect dialect, L parent) {
        this.dialect = dialect;
        this.parent = parent;
    }

    public String build() {
        Expression last;
        StringBuilder result = new StringBuilder();
        if (this.conditions.size() > 0 && (last = this.conditions.get(this.conditions.size() - 1)) instanceof SqlLogicExpression) {
            throw new BuilderException(((SqlLogicExpression)last).getLogicOperator() + " \u540e\u6ca1\u6709\u8ddf\u6761\u4ef6\u8868\u8fbe\u5f0f");
        }
        ArrayList<String> availableConditions = new ArrayList<String>();
        ArrayList<Expression> availableExpressions = new ArrayList<Expression>();
        for (Expression expression : this.conditions) {
            Expression pre;
            String condition = expression.expression();
            if (StringUtils.isNotBlank((String)condition)) {
                availableConditions.add(condition);
                availableExpressions.add(expression);
                continue;
            }
            if (availableExpressions.size() <= 0 || !((pre = (Expression)availableExpressions.get(availableExpressions.size() - 1)) instanceof SqlLogicExpression)) continue;
            availableExpressions.remove(availableExpressions.size() - 1);
            availableConditions.remove(availableConditions.size() - 1);
        }
        if (availableExpressions.size() > 0) {
            if (availableExpressions.get(0) instanceof SqlLogicExpression) {
                availableExpressions.remove(0);
                availableConditions.remove(0);
            }
            if (availableExpressions.get(availableExpressions.size() - 1) instanceof SqlLogicExpression) {
                availableExpressions.remove(availableExpressions.size() - 1);
                availableConditions.remove(availableConditions.size() - 1);
            }
        }
        for (String condition : availableConditions) {
            ConditionBuildUtils.appendCondition((StringBuilder)result, (String)condition);
        }
        if (result.length() > 0 && this.parent != null) {
            return " ( " + result.toString() + " ) ";
        }
        return result.toString();
    }

    public String expression() {
        return this.build();
    }

    public Object getParam() {
        return this.getParams();
    }

    public List<Object> getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Expression condition : this.conditions) {
            Object param;
            if (!(condition instanceof ParamedExpression) || !LangUtils.isNotEmpty((Object)(param = ((ParamedExpression)condition).getParam()))) continue;
            if (param instanceof Collection) {
                params.addAll((Collection)param);
                continue;
            }
            if (param.getClass().isArray()) {
                int length = Array.getLength(param);
                for (int i = 0; i < length; ++i) {
                    params.add(Array.get(param, i));
                }
                continue;
            }
            params.add(param);
        }
        return params;
    }

    public String toString() {
        return this.build();
    }

    protected <T, R> String getPropertyName(SerializableFunction<T, R> name) {
        return LambdaUtils.getLambdaPropertyName(name);
    }

    protected Object addCondition(Expression condition) {
        if (this.previousCondition != null && this.previousCondition.getClass().isInstance(condition)) {
            throw new BuilderException("\u8bed\u6cd5\u9519\u8bef\uff0c\u8fde\u7eed\u76f8\u540c\u7c7b\u578b\u7684\u8868\u8fbe\u5f0f\uff1a" + condition.getClass().getName());
        }
        this.previousCondition = condition;
        this.conditions.add(condition);
        return this;
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }

    public List<Expression> getConditions() {
        return this.conditions;
    }
}

