/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.sql.dialect;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.hammer.dml.builder.BuilderException;
import cn.featherfly.hammer.operator.AggregateFunction;
import cn.featherfly.hammer.operator.Function;
import cn.featherfly.hammer.operator.LogicOperator;
import cn.featherfly.hammer.operator.SortOperator;
import cn.featherfly.hammer.sqldb.sql.model.TableElement;

public interface Dialect
extends cn.featherfly.common.db.dialect.Dialect {
    default public String getKeyword(SortOperator keywords) {
        if (this.isKeywordsUppercase()) {
            return keywords.toString();
        }
        return keywords.toString().toLowerCase();
    }

    default public String getKeyword(LogicOperator keywords) {
        if (this.isKeywordsUppercase()) {
            return keywords.toString();
        }
        return keywords.toString().toLowerCase();
    }

    default public String getFunction(Function function) {
        if (this.isKeywordsUppercase()) {
            return function.toString().toUpperCase();
        }
        return function.toString().toLowerCase();
    }

    default public String buildTableSql(TableElement table) {
        return this.buildTableSql(table.getName(), table.getAlias());
    }

    default public String buildColumnSql(String columnName, Function function) {
        return this.buildColumnSql(columnName, null, function);
    }

    default public String buildColumnSql(String columnName, AggregateFunction aggregateFunction) {
        return this.buildColumnSql(columnName, null, aggregateFunction);
    }

    default public String buildColumnSql(String columnName, String tableAlias) {
        return this.buildColumnSql(columnName, tableAlias, null, null);
    }

    default public String buildColumnSql(String columnName, String tableAlias, String asName) {
        return this.buildColumnSql(columnName, tableAlias, null, asName);
    }

    default public String buildColumnSql(String columnName, String tableAlias, AggregateFunction aggregateFunction) {
        return this.buildColumnSql(columnName, tableAlias, aggregateFunction, null);
    }

    default public String buildColumnSql(String columnName, String tableAlias, AggregateFunction aggregateFunction, String asName) {
        String column = columnName;
        if (!"*".equals(columnName)) {
            column = this.wrapName(this.convertTableOrColumnName(columnName));
        }
        if (LangUtils.isNotEmpty((String)tableAlias) && !"*".equals(columnName)) {
            column = tableAlias + "." + column;
        }
        if (aggregateFunction != null) {
            switch (aggregateFunction) {
                case DISTINCT: {
                    column = this.getFunction((Function)aggregateFunction) + " " + column;
                    break;
                }
                default: {
                    column = this.getFunction((Function)aggregateFunction) + "(" + column + ")";
                }
            }
        }
        if (LangUtils.isNotEmpty((String)asName)) {
            column = column + " " + this.wrapName(asName);
        }
        return column;
    }

    default public String buildColumnSql(String columnName, String tableAlias, Function function) {
        if (function instanceof AggregateFunction) {
            return this.buildColumnSql(columnName, tableAlias, (AggregateFunction)function);
        }
        throw new BuilderException("\u53ea\u5b9e\u73b0\u4e86 AggregateFunction");
    }
}

