/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.hammer.mapping.ClassMapping;
import cn.featherfly.hammer.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractExecuteOperate;
import java.util.ArrayList;
import java.util.Collection;

public class UpdateOperate<T>
extends AbstractExecuteOperate<T> {
    public UpdateOperate(Jdbc jdbc, ClassMapping<T> classMapping) {
        super(jdbc, classMapping);
    }

    public UpdateOperate(Jdbc jdbc, ClassMapping<T> classMapping, String dataBase) {
        super(jdbc, classMapping, dataBase);
    }

    public UpdateOperate(Jdbc jdbc, ClassMapping<T> classMapping, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, databaseMetadata);
    }

    @Override
    public void initSql() {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(this.jdbc.getDialect().getKeywords().update()).append(" ").append(this.jdbc.getDialect().wrapName(this.classMapping.getRepositoryName())).append(" ").append(this.jdbc.getDialect().getKeywords().set()).append(" ");
        int columnNum = 0;
        ArrayList<PropertyMapping> pms = new ArrayList<PropertyMapping>();
        for (PropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)propertyMapping.getPropertyMappings())) {
                if (propertyMapping.isPrimaryKey()) {
                    pms.add(propertyMapping);
                    continue;
                }
                updateSql.append(this.jdbc.getDialect().wrapName(propertyMapping.getRepositoryFieldName())).append(" = ? ,");
                this.propertyPositions.put(++columnNum, propertyMapping.getPropertyName());
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                if (subPropertyMapping.isPrimaryKey()) {
                    pms.add(subPropertyMapping);
                    continue;
                }
                updateSql.append(this.jdbc.getDialect().wrapName(subPropertyMapping.getRepositoryFieldName())).append(" = ? ,");
                this.propertyPositions.put(++columnNum, propertyMapping.getPropertyName() + "." + subPropertyMapping.getPropertyName());
            }
        }
        if (columnNum > 0) {
            updateSql.deleteCharAt(updateSql.length() - 1);
        }
        int pkNum = 0;
        updateSql.append("where ");
        for (PropertyMapping pm : pms) {
            if (pkNum > 0) {
                updateSql.append(this.jdbc.getDialect().getKeywords().and()).append(" ");
            }
            updateSql.append(this.jdbc.getDialect().wrapName(pm.getRepositoryFieldName())).append(" = ? ");
            ++pkNum;
            if (pm.getParent() == null) {
                this.propertyPositions.put(columnNum + pkNum, pm.getPropertyName());
                continue;
            }
            this.propertyPositions.put(columnNum + pkNum, pm.getParent().getPropertyName() + "." + pm.getPropertyName());
        }
        this.sql = updateSql.toString();
        this.logger.debug("sql: {}", (Object)this.sql);
    }
}

