/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.hammer.mapping.ClassMapping;
import cn.featherfly.hammer.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.mapping.ClassMappingUtils;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractOperate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MergeOperate<T>
extends AbstractOperate<T> {
    public MergeOperate(Jdbc jdbc, ClassMapping<T> classMapping) {
        super(jdbc, classMapping);
    }

    public MergeOperate(Jdbc jdbc, ClassMapping<T> classMapping, String dataBase) {
        super(jdbc, classMapping, dataBase);
    }

    public MergeOperate(Jdbc jdbc, ClassMapping<T> classMapping, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, databaseMetadata);
    }

    public int execute(T entity, boolean onlyNull) {
        HashMap<Integer, String> propertyPositions = new HashMap<Integer, String>();
        String sql = this.getDynamicSql(entity, propertyPositions, onlyNull);
        return this.jdbc.update(sql, this.getParameters(entity, propertyPositions));
    }

    private String getDynamicSql(T entity, Map<Integer, String> propertyPositions, boolean onlyNull) {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(this.jdbc.getDialect().getKeywords().update()).append(" ").append(this.jdbc.getDialect().wrapName(this.classMapping.getRepositoryName())).append(" ").append(this.jdbc.getDialect().getKeywords().set()).append(" ");
        int columnNum = 0;
        ArrayList<PropertyMapping> pkms = new ArrayList<PropertyMapping>();
        for (PropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            if (propertyMapping.getPropertyMappings().isEmpty()) {
                if (this.checkNullOrEmpty(entity, propertyMapping, onlyNull)) continue;
                if (propertyMapping.isPrimaryKey()) {
                    pkms.add(propertyMapping);
                    continue;
                }
                columnNum = this.set(entity, propertyMapping, updateSql, propertyPositions, columnNum);
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                if (this.checkNullOrEmpty(entity, subPropertyMapping, onlyNull)) continue;
                if (subPropertyMapping.isPrimaryKey()) {
                    pkms.add(subPropertyMapping);
                    continue;
                }
                columnNum = this.set(entity, subPropertyMapping, updateSql, propertyPositions, columnNum);
            }
        }
        if (columnNum > 0) {
            updateSql.deleteCharAt(updateSql.length() - 1);
        }
        int pkNum = 0;
        updateSql.append(this.jdbc.getDialect().getKeywords().where()).append(" ");
        for (PropertyMapping pm : pkms) {
            if (pkNum > 0) {
                updateSql.append(this.jdbc.getDialect().getKeywords().and()).append(" ");
            }
            updateSql.append(this.jdbc.getDialect().wrapName(pm.getRepositoryFieldName())).append(" = ? ");
            propertyPositions.put(columnNum + ++pkNum, ClassMappingUtils.getPropertyAliasName(pm));
        }
        this.sql = updateSql.toString();
        return updateSql.toString();
    }

    private boolean checkNullOrEmpty(T entity, PropertyMapping propertyMapping, boolean onlyNull) {
        String pn = ClassMappingUtils.getPropertyAliasName(propertyMapping);
        if (onlyNull) {
            return BeanUtils.getProperty(entity, (String)pn) == null;
        }
        return LangUtils.isEmpty((Object)BeanUtils.getProperty(entity, (String)pn));
    }

    private int set(T entity, PropertyMapping propertyMapping, StringBuilder updateSql, Map<Integer, String> propertyPositions, int columnNum) {
        updateSql.append(this.jdbc.getDialect().wrapName(propertyMapping.getRepositoryFieldName())).append(" = ? ,");
        propertyPositions.put(++columnNum, ClassMappingUtils.getPropertyAliasName(propertyMapping));
        return columnNum;
    }

    @Override
    protected void initSql() {
    }
}

