/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.hammer.mapping.ClassMapping;
import cn.featherfly.hammer.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractExecuteOperate;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InsertOperate<T>
extends AbstractExecuteOperate<T> {
    public InsertOperate(Jdbc jdbc, ClassMapping<T> classMapping) {
        super(jdbc, classMapping);
    }

    public InsertOperate(Jdbc jdbc, ClassMapping<T> classMapping, String dataBase) {
        super(jdbc, classMapping, dataBase);
    }

    public InsertOperate(Jdbc jdbc, ClassMapping<T> classMapping, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, databaseMetadata);
    }

    @Override
    public int execute(T entity) {
        return this.jdbc.execute(con -> {
            List pks = this.classMapping.getPrivaryKeyPropertyMappings();
            PreparedStatement prep = null;
            prep = pks.size() == 1 ? con.prepareStatement(this.sql, 1) : con.prepareStatement(this.sql);
            this.setParameter(prep, entity);
            this.logger.debug("execute sql: {}", (Object)this.sql);
            int result = prep.executeUpdate();
            if (pks.size() == 1) {
                PropertyMapping pm = (PropertyMapping)pks.get(0);
                ResultSet res = prep.getGeneratedKeys();
                StringBuilder msg = null;
                if (this.logger.isDebugEnabled()) {
                    msg = new StringBuilder("\u81ea\u52a8\u751f\u6210\u7684\u952e\u503c : ");
                }
                if (res.next()) {
                    Object value = JdbcUtils.getResultSetValue((ResultSet)res, (int)1, (Class)pm.getPropertyType());
                    if (this.logger.isDebugEnabled()) {
                        msg.append(" ").append(value).append(", ");
                    }
                    BeanUtils.setProperty((Object)entity, (String)pm.getPropertyName(), (Object)value);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(msg.toString());
                }
            }
            prep.close();
            return result;
        });
    }

    @Override
    public void initSql() {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append(this.jdbc.getDialect().getKeywords().insert()).append(" ").append(this.jdbc.getDialect().getKeywords().into()).append(" ").append(this.jdbc.getDialect().wrapName(this.classMapping.getRepositoryName())).append(" ( ");
        ArrayList<PropertyMapping> pms = new ArrayList<PropertyMapping>();
        for (PropertyMapping pm : this.classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)pm.getPropertyMappings())) {
                insertSql.append(this.jdbc.getDialect().wrapName(pm.getRepositoryFieldName())).append(",");
                pms.add(pm);
                continue;
            }
            for (PropertyMapping pm2 : pm.getPropertyMappings()) {
                insertSql.append(this.jdbc.getDialect().wrapName(pm2.getRepositoryFieldName())).append(",");
                pms.add(pm2);
            }
        }
        if (pms.size() > 0) {
            insertSql.deleteCharAt(insertSql.length() - 1);
        }
        insertSql.append(" ) ").append(this.jdbc.getDialect().getKeywords().values()).append(" ( ");
        int paramNum = 0;
        for (int i = 0; i < pms.size(); ++i) {
            PropertyMapping pm = (PropertyMapping)pms.get(i);
            if (pm.isPrimaryKey() && pm.getDefaultValue() != null && !"null".equalsIgnoreCase(pm.getDefaultValue())) {
                insertSql.append(pm.getDefaultValue()).append(",");
                continue;
            }
            ++paramNum;
            insertSql.append("?").append(",");
            if (pm.getParent() == null) {
                this.propertyPositions.put(paramNum, pm.getPropertyName());
                continue;
            }
            this.propertyPositions.put(paramNum, pm.getParent().getPropertyName() + "." + pm.getPropertyName());
        }
        if (pms.size() > 0) {
            insertSql.deleteCharAt(insertSql.length() - 1);
        }
        insertSql.append(" )");
        this.sql = insertSql.toString();
        this.logger.debug("sql: {}", (Object)this.sql);
    }
}

