/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.hammer.mapping.ClassMapping;
import cn.featherfly.hammer.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.mapping.ClassMappingUtils;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractQueryOperate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GetOperate<T>
extends AbstractQueryOperate<T> {
    private List<PropertyMapping> pkPms;

    public GetOperate(Jdbc jdbc, ClassMapping<T> classMapping) {
        super(jdbc, classMapping);
    }

    public GetOperate(Jdbc jdbc, ClassMapping<T> classMapping, String dataBase) {
        super(jdbc, classMapping, dataBase);
    }

    public GetOperate(Jdbc jdbc, ClassMapping<T> classMapping, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, databaseMetadata);
    }

    public Serializable getId(T entity) {
        if (entity == null) {
            return null;
        }
        if (this.pkPms.size() == 1) {
            return (Serializable)BeanUtils.getProperty(entity, (String)this.pkPms.get(0).getPropertyName());
        }
        if (this.pkPms.size() > 1) {
            throw new SqldbHammerException("multy id defined in entity [" + entity.getClass().getName() + "], you can invoke getIds(entity) method instead");
        }
        this.logger.debug("no id defined in entity {}", (Object)entity.getClass().getName());
        return null;
    }

    public List<Serializable> getIds(T entity) {
        if (entity == null) {
            return null;
        }
        return this.pkPms.stream().map(p -> (Serializable)BeanUtils.getProperty((Object)entity, (String)ClassMappingUtils.getPropertyAliasName(p))).collect(Collectors.toList());
    }

    public T get(Serializable id) {
        if (id == null) {
            throw new SqldbHammerException("#get.id.null");
        }
        return this.jdbc.querySingle(this.sql, new Object[]{id}, (res, rowNum) -> this.mapRow(res, rowNum));
    }

    public T get(T entity) {
        if (entity == null) {
            throw new SqldbHammerException("#get.id.null");
        }
        List<Serializable> ids = this.getIds(entity);
        if (LangUtils.isEmpty(ids)) {
            throw new SqldbHammerException("#get.id.null");
        }
        return this.jdbc.querySingle(this.sql, ids.toArray(), (res, rowNum) -> this.mapRow(res, rowNum));
    }

    @Override
    protected String initCondition() {
        this.pkPms = new ArrayList<PropertyMapping>();
        StringBuilder condition = new StringBuilder();
        int columnNum = 0;
        for (PropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            if (propertyMapping.getPropertyMappings().isEmpty()) {
                columnNum = this.setPk(condition, columnNum, propertyMapping);
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                columnNum = this.setPk(condition, columnNum, subPropertyMapping);
            }
        }
        this.logger.debug("condition -> " + condition.toString());
        return condition.toString();
    }

    private int setPk(StringBuilder condition, int columnNum, PropertyMapping pm) {
        if (pm.isPrimaryKey()) {
            if (columnNum > 0) {
                condition.append("and ");
            }
            condition.append(this.jdbc.getDialect().wrapName(pm.getRepositoryFieldName())).append(" = ? ");
            this.propertyPositions.put(++columnNum, ClassMappingUtils.getPropertyAliasName(pm));
            this.pkPms.add(pm);
        }
        return columnNum;
    }
}

