/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.hammer.mapping.ClassMapping;
import cn.featherfly.hammer.mapping.PropertyMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractExecuteOperate;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.Collection;

public class DeleteOperate<T>
extends AbstractExecuteOperate<T> {
    public DeleteOperate(Jdbc jdbc, ClassMapping<T> classMapping) {
        super(jdbc, classMapping);
    }

    public DeleteOperate(Jdbc jdbc, ClassMapping<T> classMapping, String dataBase) {
        super(jdbc, classMapping, dataBase);
    }

    public DeleteOperate(Jdbc jdbc, ClassMapping<T> classMapping, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, databaseMetadata);
    }

    public int delete(Serializable id) {
        return this.jdbc.execute(con -> {
            PreparedStatement prep = null;
            prep = con.prepareStatement(this.sql);
            this.setParameter(prep, id);
            this.logger.debug("execute sql: {}", (Object)this.sql);
            int result = prep.executeUpdate();
            prep.close();
            return result;
        });
    }

    @Override
    public void initSql() {
        StringBuilder deleteSql = new StringBuilder();
        deleteSql.append(this.jdbc.getDialect().getKeywords().delete()).append(" ").append(this.jdbc.getDialect().getKeywords().from()).append(" ").append(this.jdbc.getDialect().wrapName(this.classMapping.getRepositoryName())).append(" ").append(this.jdbc.getDialect().getKeywords().where()).append(" ");
        int columnNum = 0;
        for (PropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)propertyMapping.getPropertyMappings())) {
                if (!propertyMapping.isPrimaryKey()) continue;
                if (columnNum > 0) {
                    deleteSql.append(this.jdbc.getDialect().getKeywords().and()).append(" ");
                }
                deleteSql.append(this.jdbc.getDialect().wrapName(propertyMapping.getRepositoryFieldName())).append(" = ? ");
                this.propertyPositions.put(++columnNum, propertyMapping.getPropertyName());
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                if (!subPropertyMapping.isPrimaryKey()) continue;
                if (columnNum > 0) {
                    deleteSql.append(this.jdbc.getDialect().getKeywords().and()).append(" ");
                }
                deleteSql.append(this.jdbc.getDialect().wrapName(subPropertyMapping.getRepositoryFieldName())).append(" = ? ");
                this.propertyPositions.put(++columnNum, propertyMapping.getPropertyName() + "." + subPropertyMapping.getPropertyName());
            }
        }
        this.sql = deleteSql.toString();
        this.logger.debug("sql: {}", (Object)this.sql);
    }
}

