/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.hammer.dsl.query.TypeQueryConditionGroupExpression;
import cn.featherfly.hammer.dsl.query.TypeQueryConditionGroupLogicExpression;
import cn.featherfly.hammer.dsl.query.TypeQuerySortExpression;
import cn.featherfly.hammer.expression.query.TypeQueryLimitExecutor;
import cn.featherfly.hammer.mapping.ClassMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.mapping.ClassMappingUtils;
import cn.featherfly.hammer.sqldb.sql.dml.AbstractSqlConditionGroupExpression;
import cn.featherfly.hammer.sqldb.sql.dml.builder.SqlSortBuilder;
import java.util.Arrays;
import java.util.List;

public class TypeSqlQueryConditionGroupExpression
extends AbstractSqlConditionGroupExpression<TypeQueryConditionGroupExpression, TypeQueryConditionGroupLogicExpression>
implements TypeQueryConditionGroupExpression,
TypeQueryConditionGroupLogicExpression,
TypeQuerySortExpression {
    private SqlSortBuilder sortBuilder;
    private Limit limit;
    protected Jdbc jdbc;

    public TypeSqlQueryConditionGroupExpression(Jdbc jdbc, ClassMapping<?> classMapping) {
        this(jdbc, null, classMapping);
    }

    public TypeSqlQueryConditionGroupExpression(Jdbc jdbc, String queryAlias, ClassMapping<?> classMapping) {
        this(jdbc, null, queryAlias, classMapping);
    }

    TypeSqlQueryConditionGroupExpression(Jdbc jdbc, TypeQueryConditionGroupLogicExpression parent, String queryAlias, ClassMapping<?> classMapping) {
        super(jdbc.getDialect(), parent, queryAlias, classMapping);
        this.sortBuilder = new SqlSortBuilder(this.dialect);
        this.jdbc = jdbc;
    }

    @Override
    protected TypeSqlQueryConditionGroupExpression createGroup(TypeQueryConditionGroupLogicExpression parent, String queryAlias) {
        return new TypeSqlQueryConditionGroupExpression(this.jdbc, parent, queryAlias, this.classMapping);
    }

    @Override
    public String build() {
        String condition = super.build();
        if (this.parent == null) {
            if (LangUtils.isNotEmpty((String)condition)) {
                return this.dialect.getKeywords().where() + " " + super.build() + " " + this.sortBuilder.build();
            }
            return super.build() + " " + this.sortBuilder.build();
        }
        return super.build();
    }

    public TypeQueryLimitExecutor limit(Integer limit) {
        return this.limit(0, limit);
    }

    public TypeQueryLimitExecutor limit(Integer offset, Integer limit) {
        return this.limit(new Limit(offset, limit));
    }

    public TypeQueryLimitExecutor limit(Page page) {
        return this.limit(new Limit(page));
    }

    private TypeQueryLimitExecutor limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public <E> List<E> list() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset(), this.limit.getLimit());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset(), this.limit.getLimit());
        }
        return this.jdbc.query(sql, params, this.classMapping.getType());
    }

    public <E> PaginationResults<E> pagination() {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            List list = this.jdbc.query(this.dialect.getPaginationSql(sql, this.limit.getOffset(), this.limit.getLimit()), this.dialect.getPaginationSqlParameter(params, this.limit.getOffset(), this.limit.getLimit()), this.classMapping.getType());
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List list = this.jdbc.query(sql, params, this.classMapping.getType());
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public <E> E single() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset(), this.limit.getLimit());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset(), this.limit.getLimit());
        }
        return (E)this.jdbc.querySingle(sql, params, this.classMapping.getType());
    }

    public Long count() {
        throw new UnsupportedException();
    }

    public TypeQuerySortExpression sort() {
        return this;
    }

    public TypeQuerySortExpression asc(String ... names) {
        ((TypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.asc(ClassMappingUtils.getColumnNames(this.classMapping, names));
        return this;
    }

    public TypeQuerySortExpression asc(List<String> names) {
        ((TypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.asc(ClassMappingUtils.getColumnNames(this.classMapping, names));
        return this;
    }

    public <T, R> TypeQuerySortExpression asc(SerializableFunction<T, R> name) {
        return this.asc(this.getPropertyName(name));
    }

    public <T, R> TypeQuerySortExpression asc(SerializableFunction<T, R> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.asc(nameArray);
    }

    public TypeQuerySortExpression desc(String ... names) {
        ((TypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.desc(ClassMappingUtils.getColumnNames(this.classMapping, names));
        return this;
    }

    public TypeQuerySortExpression desc(List<String> names) {
        ((TypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.desc(ClassMappingUtils.getColumnNames(this.classMapping, names));
        return this;
    }

    public <T, R> TypeQuerySortExpression desc(SerializableFunction<T, R> name) {
        return this.desc(this.getPropertyName(name));
    }

    public <T, R> TypeQuerySortExpression desc(SerializableFunction<T, R> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.desc(nameArray);
    }
}

