/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.hammer.dml.AliasManager;
import cn.featherfly.hammer.dsl.query.QueryWith;
import cn.featherfly.hammer.dsl.query.RepositoryQueryConditionGroupExpression;
import cn.featherfly.hammer.expression.query.QueryLimitExecutor;
import cn.featherfly.hammer.mapping.ClassMapping;
import cn.featherfly.hammer.mapping.MappingFactory;
import cn.featherfly.hammer.mapping.RowMapper;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.RepositorySqlQueryExpression;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryEntityProperties;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryWithEntity;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryWithOn;
import cn.featherfly.hammer.sqldb.jdbc.mapping.ClassMappingUtils;
import cn.featherfly.hammer.sqldb.sql.dml.builder.basic.SqlSelectJoinOnBasicBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlQueryWith
implements QueryWith,
SqlQueryWithOn,
SqlQueryWithEntity {
    private SqlQueryEntityProperties sqlQueryEntityProperties;
    private AliasManager aliasManager;
    private String selectTableAlis;
    private String selectTableColumn;
    private String joinTableName;
    private String joinTableAlias;
    private SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
    private MappingFactory factory;
    private ClassMapping<?> classMapping;

    public SqlQueryWith(SqlQueryEntityProperties sqlQueryEntityProperties, AliasManager aliasManager, MappingFactory factory, String selectTableAlis, String selectTableColumn, String joinTableName, String joinTableAlias) {
        this.sqlQueryEntityProperties = sqlQueryEntityProperties;
        this.aliasManager = aliasManager;
        this.factory = factory;
        this.selectTableAlis = selectTableAlis;
        this.selectTableColumn = selectTableColumn;
        this.joinTableName = joinTableName;
        this.joinTableAlias = joinTableAlias;
    }

    public SqlQueryWith(SqlQueryEntityProperties sqlQueryEntityProperties, AliasManager aliasManager, MappingFactory factory, String selectTableAlis, String selectTableColumn, Class<?> joinType) {
        this.sqlQueryEntityProperties = sqlQueryEntityProperties;
        this.aliasManager = aliasManager;
        this.factory = factory;
        this.selectTableAlis = selectTableAlis;
        this.selectTableColumn = selectTableColumn;
        this.classMapping = factory.getClassMapping(joinType);
        this.joinTableName = this.classMapping.getRepositoryName();
        this.joinTableAlias = aliasManager.put(this.classMapping.getRepositoryName());
    }

    public SqlQueryWithOn with(String repositoryName) {
        return new SqlQueryWith(this.sqlQueryEntityProperties, this.aliasManager, this.factory, this.selectTableAlis, this.selectTableColumn, repositoryName, this.aliasManager.put(repositoryName));
    }

    public <T> SqlQueryWithOn with(Class<T> repositoryType) {
        return new SqlQueryWith(this.sqlQueryEntityProperties, this.aliasManager, this.factory, this.selectTableAlis, this.selectTableColumn, repositoryType);
    }

    @Override
    public SqlQueryWithEntity on(String propertyName) {
        return this.on2(propertyName, this.selectTableAlis, this.selectTableColumn);
    }

    @Override
    public SqlQueryWithEntity on(String propertyName, String findRepositoryPropertyName) {
        return this.on2(propertyName, this.selectTableAlis, findRepositoryPropertyName);
    }

    @Override
    public SqlQueryWithEntity on(String propertyName, String repositoryName, String repositoryPropertyName) {
        return this.on2(propertyName, this.aliasManager.getAlias(repositoryName), repositoryPropertyName);
    }

    private SqlQueryWithEntity on2(String columnName, String tableAlias, String tableColumn) {
        this.selectJoinOnBasicBuilder = this.classMapping == null ? this.sqlQueryEntityProperties.getSelectBuilder().join(tableAlias, tableColumn, this.joinTableName, this.joinTableAlias, columnName) : this.sqlQueryEntityProperties.getSelectBuilder().join(tableAlias, tableColumn, this.classMapping, this.joinTableAlias, columnName);
        return this;
    }

    public <T, R> SqlQueryWithEntity fetch(SerializableFunction<T, R> propertyName) {
        return this.fetch(LambdaUtils.getLambdaPropertyName(propertyName));
    }

    public SqlQueryWithEntity fetch(String propertyName) {
        this.selectJoinOnBasicBuilder.addSelectColumn(ClassMappingUtils.getColumnName(propertyName, this.classMapping));
        return this;
    }

    public SqlQueryWithEntity fetch(String ... propertyNames) {
        this.selectJoinOnBasicBuilder.addSelectColumns(ClassMappingUtils.getColumnNames(this.classMapping, propertyNames));
        return this;
    }

    public <T, R> SqlQueryWithEntity fetch(SerializableFunction<T, R> ... propertyNames) {
        return this.fetch((Collection<String>)Arrays.stream(propertyNames).map(LambdaUtils::getLambdaPropertyName).collect(Collectors.toList()));
    }

    public SqlQueryWithEntity fetch(Collection<String> propertyNames) {
        this.selectJoinOnBasicBuilder.addSelectColumns(ClassMappingUtils.getColumnNames(this.classMapping, propertyNames));
        return this;
    }

    @Override
    public <T, R> SqlQueryWithEntity fetchAlias(SerializableFunction<T, R> propertyName, String aliasName) {
        return this.fetchAlias(LambdaUtils.getLambdaPropertyName(propertyName), aliasName);
    }

    @Override
    public SqlQueryWithEntity fetchAlias(String columnName, String aliasName) {
        this.selectJoinOnBasicBuilder.addSelectColumn(ClassMappingUtils.getColumnName(columnName, this.classMapping), aliasName);
        return this;
    }

    @Override
    public SqlQueryWithEntity fetchAlias(Map<String, String> columnNameMap) {
        columnNameMap.forEach((k, v) -> this.fetchAlias((String)k, (String)v));
        return this;
    }

    public QueryWith fetch() {
        this.selectJoinOnBasicBuilder.fetch();
        return this;
    }

    public RepositoryQueryConditionGroupExpression where() {
        return new RepositorySqlQueryExpression(this.sqlQueryEntityProperties.jdbc, this.factory, this.aliasManager, this.classMapping, this.sqlQueryEntityProperties.selectBuilder);
    }

    public List<Map<String, Object>> list() {
        return this.sqlQueryEntityProperties.list();
    }

    public <E> List<E> list(Class<E> type) {
        return this.sqlQueryEntityProperties.list(type);
    }

    public <E> List<E> list(RowMapper<E> rowMapper) {
        return this.sqlQueryEntityProperties.list(rowMapper);
    }

    public QueryLimitExecutor limit(Integer limit) {
        return this.sqlQueryEntityProperties.limit(limit);
    }

    public QueryLimitExecutor limit(Integer offset, Integer limit) {
        return this.sqlQueryEntityProperties.limit(offset, limit);
    }

    public QueryLimitExecutor limit(Page page) {
        return this.sqlQueryEntityProperties.limit(page);
    }
}

