/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.hammer.dml.AliasManager;
import cn.featherfly.hammer.dsl.query.Query;
import cn.featherfly.hammer.expression.Repository;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.SqlQueryEntityProperties;
import cn.featherfly.hammer.sqldb.jdbc.dsl.query.TypeSqlQueryEntityProperties;
import cn.featherfly.hammer.sqldb.jdbc.mapping.JdbcMappingFactory;

public class SqlQuery
implements Query {
    private Jdbc jdbc;
    private DatabaseMetadata databaseMetadata;
    private JdbcMappingFactory mappingFactory;

    public SqlQuery(Jdbc jdbc, DatabaseMetadata databaseMetadata) {
        this.jdbc = jdbc;
        this.databaseMetadata = databaseMetadata;
    }

    public SqlQuery(Jdbc jdbc, JdbcMappingFactory mappingFactory) {
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.databaseMetadata = mappingFactory.getMetadata();
    }

    public SqlQueryEntityProperties find(Repository repository) {
        if (repository == null) {
            return null;
        }
        AliasManager aliasManager = new AliasManager();
        String alias = repository.alias();
        if (LangUtils.isNotEmpty((String)alias)) {
            aliasManager.put(repository.name(), alias);
        } else {
            alias = aliasManager.put(repository.name());
        }
        return new SqlQueryEntityProperties(this.jdbc, this.databaseMetadata, repository.name(), alias, this.mappingFactory, aliasManager);
    }

    public SqlQueryEntityProperties find(String tableName) {
        return new SqlQueryEntityProperties(this.jdbc, this.databaseMetadata, tableName, this.mappingFactory, new AliasManager());
    }

    public TypeSqlQueryEntityProperties find(Class<?> repositType) {
        if (this.mappingFactory == null) {
            throw new SqldbHammerException("mappingFactory is null");
        }
        return new TypeSqlQueryEntityProperties(this.jdbc, this.mappingFactory.getClassMapping(repositType), this.mappingFactory, new AliasManager());
    }
}

