/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.query;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.hammer.dml.AliasManager;
import cn.featherfly.hammer.dsl.query.RepositoryTypeQueryConditionGroupExpression;
import cn.featherfly.hammer.dsl.query.RepositoryTypeQueryConditionGroupLogicExpression;
import cn.featherfly.hammer.dsl.query.TypeQuerySortExpression;
import cn.featherfly.hammer.expression.query.TypeQueryLimitExecutor;
import cn.featherfly.hammer.mapping.ClassMapping;
import cn.featherfly.hammer.mapping.MappingFactory;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.mapping.ClassMappingUtils;
import cn.featherfly.hammer.sqldb.sql.dml.AbstractRepositorySqlConditionGroupExpression;
import cn.featherfly.hammer.sqldb.sql.dml.builder.SqlSortBuilder;
import java.util.Arrays;
import java.util.List;

public class RepositoryTypeSqlQueryConditionGroupExpression
extends AbstractRepositorySqlConditionGroupExpression<RepositoryTypeQueryConditionGroupExpression, RepositoryTypeQueryConditionGroupLogicExpression>
implements RepositoryTypeQueryConditionGroupExpression,
RepositoryTypeQueryConditionGroupLogicExpression,
TypeQuerySortExpression {
    private SqlSortBuilder sortBuilder;
    private Limit limit;
    protected Jdbc jdbc;

    public RepositoryTypeSqlQueryConditionGroupExpression(Jdbc jdbc, MappingFactory factory, AliasManager aliasManager, ClassMapping<?> classMapping) {
        this(jdbc, factory, aliasManager, null, classMapping);
    }

    public RepositoryTypeSqlQueryConditionGroupExpression(Jdbc jdbc, MappingFactory factory, AliasManager aliasManager, String queryAlias, ClassMapping<?> classMapping) {
        this(jdbc, factory, aliasManager, null, queryAlias, classMapping);
    }

    RepositoryTypeSqlQueryConditionGroupExpression(Jdbc jdbc, MappingFactory factory, AliasManager aliasManager, RepositoryTypeQueryConditionGroupLogicExpression parent, String queryAlias, ClassMapping<?> classMapping) {
        super(jdbc.getDialect(), factory, aliasManager, parent, queryAlias, classMapping);
        this.sortBuilder = new SqlSortBuilder(this.dialect);
        this.jdbc = jdbc;
    }

    @Override
    protected RepositoryTypeQueryConditionGroupExpression createGroup(RepositoryTypeQueryConditionGroupLogicExpression parent, String queryAlias) {
        return new RepositoryTypeSqlQueryConditionGroupExpression(this.jdbc, this.factory, this.aliasManager, parent, queryAlias, this.classMapping);
    }

    @Override
    public String build() {
        String condition = super.build();
        if (this.parent == null) {
            if (LangUtils.isNotEmpty((String)condition)) {
                return this.dialect.getKeywords().where() + " " + super.build() + " " + this.sortBuilder.build();
            }
            return super.build() + " " + this.sortBuilder.build();
        }
        return super.build();
    }

    public TypeQueryLimitExecutor limit(Integer limit) {
        return this.limit(0, limit);
    }

    public TypeQueryLimitExecutor limit(Integer offset, Integer limit) {
        return this.limit(new Limit(offset, limit));
    }

    public TypeQueryLimitExecutor limit(Page page) {
        return this.limit(new Limit(page));
    }

    private TypeQueryLimitExecutor limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public <E> List<E> list() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset(), this.limit.getLimit());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset(), this.limit.getLimit());
        }
        return this.jdbc.query(sql, params, this.classMapping.getType());
    }

    public <E> PaginationResults<E> pagination() {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Object[] params = this.getRoot().getParams().toArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            List list = this.jdbc.query(this.dialect.getPaginationSql(sql, this.limit.getOffset(), this.limit.getLimit()), this.dialect.getPaginationSqlParameter(params, this.limit.getOffset(), this.limit.getLimit()), this.classMapping.getType());
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal(Integer.valueOf(total));
        } else {
            List list = this.jdbc.query(sql, params, this.classMapping.getType());
            pagination.setPageResults(list);
            pagination.setTotal(Integer.valueOf(list.size()));
        }
        return pagination;
    }

    public <E> E single() {
        String sql = this.getRoot().expression();
        Object[] params = this.getRoot().getParams().toArray();
        if (this.limit != null) {
            sql = this.dialect.getPaginationSql(sql, this.limit.getOffset(), this.limit.getLimit());
            params = this.dialect.getPaginationSqlParameter(params, this.limit.getOffset(), this.limit.getLimit());
        }
        return (E)this.jdbc.querySingle(sql, params, this.classMapping.getType());
    }

    public TypeQuerySortExpression sort() {
        return this;
    }

    public TypeQuerySortExpression asc(String ... names) {
        ((RepositoryTypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.asc(ClassMappingUtils.getColumnNames(this.classMapping, names));
        return this;
    }

    public TypeQuerySortExpression asc(List<String> names) {
        ((RepositoryTypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.asc(ClassMappingUtils.getColumnNames(this.classMapping, names));
        return this;
    }

    public <T, R> TypeQuerySortExpression asc(SerializableFunction<T, R> name) {
        return this.asc(this.getPropertyName(name));
    }

    public <T, R> TypeQuerySortExpression asc(SerializableFunction<T, R> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.asc(nameArray);
    }

    public TypeQuerySortExpression desc(String ... names) {
        ((RepositoryTypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.desc(ClassMappingUtils.getColumnNames(this.classMapping, names));
        return this;
    }

    public TypeQuerySortExpression desc(List<String> names) {
        ((RepositoryTypeSqlQueryConditionGroupExpression)this.getRoot()).sortBuilder.desc(ClassMappingUtils.getColumnNames(this.classMapping, names));
        return this;
    }

    public <T, R> TypeQuerySortExpression desc(SerializableFunction<T, R> name) {
        return this.desc(this.getPropertyName(name));
    }

    public <T, R> TypeQuerySortExpression desc(SerializableFunction<T, R> ... names) {
        String[] nameArray = (String[])Arrays.stream(names).map(LambdaUtils::getLambdaPropertyName).toArray(String[]::new);
        return this.desc(nameArray);
    }
}

