/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.dsl.execute;

import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.function.SerializableFunction;
import cn.featherfly.hammer.dsl.execute.ExecutableConditionGroupExpression;
import cn.featherfly.hammer.dsl.execute.ExecutableUpdate;
import cn.featherfly.hammer.dsl.execute.SimpleUpdateNumberValue;
import cn.featherfly.hammer.dsl.execute.SimpleUpdateValue;
import cn.featherfly.hammer.dsl.execute.UpdateNumberValue;
import cn.featherfly.hammer.dsl.execute.UpdateValue;
import cn.featherfly.hammer.expression.Repository;
import cn.featherfly.hammer.mapping.ClassMapping;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.dsl.execute.SqlUpdate;
import cn.featherfly.hammer.sqldb.jdbc.dsl.execute.SqlUpdateExpression;
import cn.featherfly.hammer.sqldb.jdbc.mapping.ClassMappingUtils;
import cn.featherfly.hammer.sqldb.sql.dml.builder.basic.SqlUpdateSetBasicBuilder;
import cn.featherfly.hammer.sqldb.sql.model.UpdateColumnElement;

public class SqlExecutableUpdate
implements SqlUpdate,
ExecutableUpdate {
    private Jdbc jdbc;
    private SqlUpdateSetBasicBuilder builder;
    private ClassMapping<?> classMapping;

    public SqlExecutableUpdate(String tableName, Jdbc jdbc) {
        this.jdbc = jdbc;
        this.builder = new SqlUpdateSetBasicBuilder(jdbc.getDialect(), tableName);
    }

    public SqlExecutableUpdate(Repository repository, Jdbc jdbc) {
        this(repository.name(), jdbc);
    }

    public SqlExecutableUpdate(ClassMapping<?> classMapping, Jdbc jdbc) {
        this.classMapping = classMapping;
        this.jdbc = jdbc;
        this.builder = new SqlUpdateSetBasicBuilder(jdbc.getDialect(), classMapping.getRepositoryName());
    }

    public SqlExecutableUpdate set(String name, Object value) {
        this.builder.setValue(ClassMappingUtils.getColumnName(name, this.classMapping), value);
        return this;
    }

    public <N extends Number> SqlExecutableUpdate increase(String name, N value) {
        this.builder.setValue(ClassMappingUtils.getColumnName(name, this.classMapping), value, UpdateColumnElement.SetType.INCR);
        return this;
    }

    public <T, R> ExecutableUpdate set(SerializableFunction<T, R> name, Object value) {
        return this.set(LambdaUtils.getLambdaPropertyName(name), value);
    }

    public <T, R extends Number, N extends Number> ExecutableUpdate increase(SerializableFunction<T, R> name, N value) {
        return this.increase(LambdaUtils.getLambdaPropertyName(name), value);
    }

    public UpdateValue property(String name) {
        return new SimpleUpdateValue(ClassMappingUtils.getColumnName(name, this.classMapping), (ExecutableUpdate)this);
    }

    public UpdateNumberValue propertyNumber(String name) {
        return new SimpleUpdateNumberValue(ClassMappingUtils.getColumnName(name, this.classMapping), (ExecutableUpdate)this);
    }

    public <T, R> UpdateValue property(SerializableFunction<T, R> name) {
        return this.property(LambdaUtils.getLambdaPropertyName(name));
    }

    public <T, R extends Number> UpdateNumberValue propertyNumber(SerializableFunction<T, R> name) {
        return this.propertyNumber(LambdaUtils.getLambdaPropertyName(name));
    }

    public ExecutableConditionGroupExpression where() {
        return new SqlUpdateExpression(this.jdbc, this.builder, this.classMapping);
    }

    public int execute() {
        return new SqlUpdateExpression(this.jdbc, this.builder, this.classMapping).execute();
    }
}

