/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.hammer.mapping.ResultSet;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;

public class SqlResultSet
implements ResultSet {
    private java.sql.ResultSet proxy;

    public SqlResultSet(java.sql.ResultSet proxy) {
        this.proxy = proxy;
    }

    public int getRowNum() {
        try {
            return this.proxy.getRow();
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public String getString(int columnIndex) {
        try {
            return this.proxy.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public byte getByte(int columnIndex) {
        try {
            return this.proxy.getByte(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public int getInt(int columnIndex) {
        try {
            return this.proxy.getInt(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public long getLong(int columnIndex) {
        try {
            return this.proxy.getLong(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public float getFloat(int columnIndex) {
        try {
            return this.proxy.getFloat(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public double getDouble(int columnIndex) {
        try {
            return this.proxy.getDouble(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public byte[] getBytes(int columnIndex) {
        try {
            return this.proxy.getBytes(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public Date getDate(int columnIndex) {
        try {
            return this.proxy.getDate(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public String getString(String columnLabel) {
        try {
            return this.proxy.getString(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public byte getByte(String columnLabel) {
        try {
            return this.proxy.getByte(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public int getInt(String columnLabel) {
        try {
            return this.proxy.getInt(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public long getLong(String columnLabel) {
        try {
            return this.proxy.getLong(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public float getFloat(String columnLabel) {
        try {
            return this.proxy.getFloat(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public double getDouble(String columnLabel) {
        try {
            return this.proxy.getDouble(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public byte[] getBytes(String columnLabel) {
        try {
            return this.proxy.getBytes(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public Date getDate(String columnLabel) {
        try {
            return this.proxy.getDate(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public Object getObject(int columnIndex) {
        try {
            return this.proxy.getObject(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public Object getObject(String columnLabel) {
        try {
            return this.proxy.getObject(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) {
        try {
            return this.proxy.getBigDecimal(columnIndex);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public BigDecimal getBigDecimal(String columnLabel) {
        try {
            return this.proxy.getBigDecimal(columnLabel);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public <T> T getObject(int columnIndex, Class<T> type) {
        try {
            return this.proxy.getObject(columnIndex, type);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public <T> T getObject(String columnLabel, Class<T> type) {
        try {
            return this.proxy.getObject(columnLabel, type);
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public <T extends Enum<T>> T getEnum(int index, Class<T> type) {
        try {
            if (this.proxy.getType() == 4 || this.proxy.getType() == -6 || this.proxy.getType() == 5) {
                return (T)LangUtils.toEnum(type, (Object)this.proxy.getInt(index));
            }
            if (this.proxy.getType() == 12 || this.proxy.getType() == -9 || this.proxy.getType() == 1 || this.proxy.getType() == -15 || this.proxy.getType() == -1 || this.proxy.getType() == -16) {
                return (T)LangUtils.toEnum(type, (Object)this.proxy.getString(index));
            }
            throw new SqldbHammerException("can not convert type " + this.proxy.getType() + " to enum " + type.getName());
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> type) {
        try {
            if (this.proxy.getType() == 4 || this.proxy.getType() == -6 || this.proxy.getType() == 5) {
                return (T)LangUtils.toEnum(type, (Object)this.proxy.getInt(name));
            }
            if (this.proxy.getType() == 12 || this.proxy.getType() == -9 || this.proxy.getType() == 1 || this.proxy.getType() == -15 || this.proxy.getType() == -1 || this.proxy.getType() == -16) {
                return (T)LangUtils.toEnum(type, (Object)this.proxy.getString(name));
            }
            throw new SqldbHammerException("can not convert type " + this.proxy.getType() + " to enum " + type.getName());
        }
        catch (SQLException e) {
            throw new SqldbHammerException(e);
        }
    }

    public java.sql.ResultSet getResultSet() {
        return this.proxy;
    }
}

