/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.hammer.mapping.ResultSet;
import cn.featherfly.hammer.mapping.RowMapper;
import cn.featherfly.hammer.sqldb.Constants;
import cn.featherfly.hammer.sqldb.jdbc.ConnectionCallback;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.NestedBeanPropertyRowMapper;
import cn.featherfly.hammer.sqldb.jdbc.SqlResultSet;
import cn.featherfly.hammer.sqldb.sql.dialect.Dialect;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class SpringJdbcTemplateImpl
implements Jdbc {
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private DataSource dataSource;
    private Dialect dialect;

    public SpringJdbcTemplateImpl() {
    }

    public SpringJdbcTemplateImpl(DataSource dataSource, Dialect dialect) {
        this.setDataSource(dataSource);
        this.dialect = dialect;
    }

    @Override
    public <T> T execute(ConnectionCallback<T> action) {
        return (T)this.jdbcTemplate.execute(con -> action.doInConnection(con));
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public List<Map<String, Object>> query(String sql, Object[] args) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, (Object)ArrayUtils.toString((Object[])args));
        return this.jdbcTemplate.queryForList(sql, args);
    }

    @Override
    public List<Map<String, Object>> query(String sql, Map<String, Object> args) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, args);
        return this.namedParameterJdbcTemplate.queryForList(sql, args);
    }

    @Override
    public <T> List<T> query(String sql, Map<String, Object> args, RowMapper<T> rowMapper) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, args);
        return this.namedParameterJdbcTemplate.query(sql, args, (rs, rowNum) -> rowMapper.mapRow((ResultSet)new SqlResultSet(rs), rowNum));
    }

    @Override
    public <T> List<T> query(String sql, Object[] args, RowMapper<T> rowMapper) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, (Object)ArrayUtils.toString((Object[])args));
        return this.jdbcTemplate.query(sql, args, (rs, rowNum) -> rowMapper.mapRow((ResultSet)new SqlResultSet(rs), rowNum));
    }

    @Override
    public <T> List<T> query(String sql, Map<String, Object> args, Class<T> elementType) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, args);
        return this.namedParameterJdbcTemplate.query(sql, args, new NestedBeanPropertyRowMapper<T>(elementType));
    }

    @Override
    public <T> List<T> query(String sql, Object[] args, Class<T> elementType) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, (Object)args);
        return this.jdbcTemplate.query(sql, args, new NestedBeanPropertyRowMapper<T>(elementType));
    }

    @Override
    public Map<String, Object> querySingle(String sql, Map<String, Object> args) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, args);
        try {
            return this.namedParameterJdbcTemplate.queryForMap(sql, args);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public Map<String, Object> querySingle(String sql, Object[] args) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, (Object)ArrayUtils.toString((Object[])args));
        try {
            return this.jdbcTemplate.queryForMap(sql, args);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> T querySingle(String sql, Map<String, Object> args, Class<T> elementType) {
        Constants.LOGGER.debug("sql -> {}, args -> {} , type -> {}", new Object[]{sql, args, elementType.getName()});
        try {
            return (T)this.namedParameterJdbcTemplate.queryForObject(sql, args, new NestedBeanPropertyRowMapper<T>(elementType));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> T querySingle(String sql, Map<String, Object> args, RowMapper<T> rowMapper) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, args);
        try {
            return (T)this.namedParameterJdbcTemplate.queryForObject(sql, args, (rs, rowNum) -> rowMapper.mapRow((ResultSet)new SqlResultSet(rs), rowNum));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> T querySingle(String sql, Object[] args, Class<T> elementType) {
        Constants.LOGGER.debug("sql -> {}, args -> {} , type -> {}", new Object[]{sql, ArrayUtils.toString((Object[])args), elementType.getName()});
        try {
            return (T)this.jdbcTemplate.queryForObject(sql, args, new NestedBeanPropertyRowMapper<T>(elementType));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> T querySingle(String sql, Object[] args, RowMapper<T> rowMapper) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, (Object)ArrayUtils.toString((Object[])args));
        try {
            return (T)this.jdbcTemplate.queryForObject(sql, args, (rs, rowNum) -> rowMapper.mapRow((ResultSet)new SqlResultSet(rs), rowNum));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public BigDecimal queryBigDecimal(String sql, Map<String, Object> args) {
        return this.queryValue(sql, args, BigDecimal.class);
    }

    @Override
    public BigDecimal queryBigDecimal(String sql, Object[] args) {
        return this.queryValue(sql, args, BigDecimal.class);
    }

    @Override
    public Double queryDouble(String sql, Map<String, Object> args) {
        return this.queryValue(sql, args, Double.class);
    }

    @Override
    public Double queryDouble(String sql, Object[] args) {
        return this.queryValue(sql, args, Double.class);
    }

    @Override
    public Integer queryInt(String sql, Map<String, Object> args) {
        return this.queryValue(sql, args, Integer.class);
    }

    @Override
    public Integer queryInt(String sql, Object[] args) {
        return this.queryValue(sql, args, Integer.class);
    }

    @Override
    public Long queryLong(String sql, Map<String, Object> args) {
        return this.queryValue(sql, args, Long.class);
    }

    @Override
    public Long queryLong(String sql, Object[] args) {
        return this.queryValue(sql, args, Long.class);
    }

    @Override
    public String queryString(String sql, Map<String, Object> args) {
        return this.queryValue(sql, args, String.class);
    }

    @Override
    public String queryString(String sql, Object[] args) {
        return this.queryValue(sql, args, String.class);
    }

    @Override
    public <T> T queryValue(String sql, Map<String, Object> args, Class<T> valueType) {
        Constants.LOGGER.debug("sql -> {}, args -> {}, type -> {}", new Object[]{sql, args, valueType.getName()});
        return (T)this.namedParameterJdbcTemplate.queryForObject(sql, args, valueType);
    }

    @Override
    public <T> T queryValue(String sql, Object[] args, Class<T> valueType) {
        Constants.LOGGER.debug("sql -> {}, args -> {}, type -> {}", new Object[]{sql, ArrayUtils.toString((Object[])args), valueType.getName()});
        return (T)this.jdbcTemplate.queryForObject(sql, args, valueType);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public int update(String sql, Object ... args) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, (Object)args);
        return this.jdbcTemplate.update(sql, args);
    }

    @Override
    public int update(String sql, Map<String, Object> args) {
        Constants.LOGGER.debug("sql -> {}, args -> {}", (Object)sql, args);
        return this.namedParameterJdbcTemplate.update(sql, args);
    }
}

