/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.servlet.view.jxls;

import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.web.WebException;
import cn.featherfly.web.servlet.ServletUtils;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.jxls.transform.Transformer;
import org.jxls.util.TransformerFactory;
import org.springframework.web.servlet.view.document.AbstractXlsxView;

public class JxlsView
extends AbstractXlsxView {
    private boolean autoHeight = true;
    private String suffix = "xlsx";

    protected void buildExcelDocument(Map<String, Object> model, Workbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object path = ServletUtils.getRequestURI((HttpServletRequest)request);
        if (((String)path).indexOf(46) < 0) {
            path = (String)path + "." + this.suffix;
        }
        String name = StringUtils.substringAfterLast((String)path, (String)"/");
        try (InputStream in = this.getTemplate((String)path, name, request.getServletContext());){
            Transformer transformer = TransformerFactory.createTransformer((InputStream)in, (OutputStream)response.getOutputStream());
            transformer.write();
        }
        catch (Exception e) {
            throw new WebException((Throwable)e);
        }
    }

    private InputStream getTemplate(String filePath, String fileName, ServletContext context) {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)filePath, context.getClass());
        if (is == null) {
            is = ClassLoaderUtils.getResourceAsStream((String)("/" + fileName), context.getClass());
        }
        if (Lang.isEmpty((Object)is)) {
            throw new WebException("\u672a\u627e\u5230[" + filePath + "," + fileName + "]\u5bf9\u5e94\u7684\u6a21\u677f");
        }
        return is;
    }

    public boolean isAutoHeight() {
        return this.autoHeight;
    }

    public void setAutoHeight(boolean autoHeight) {
        this.autoHeight = autoHeight;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

