/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.servlet.view.json;

import cn.featherfly.common.lang.Lang;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class ObjectMapperConfiguration {
    private String dateFormat;
    private JsonInclude.Include include;
    private Boolean writeNumbersAsStrings;
    private Boolean escapeNonAscii;
    private Boolean writeNanAsStrings;
    private Boolean quoteFieldNames;
    private Boolean allowBackslashEscapingAnyCharacter;
    private Boolean allowJavaComments;
    private Boolean allowYamlComments;
    private Boolean allowSingleQuotes;
    private Boolean allowUnquotedFieldNames;
    private Boolean allowUnescapedControlChars;
    private Boolean allowLeadingDecimalPointForNumbers;
    private Boolean allowLeadingZerosForNumbers;
    private Boolean allowNonNumericNumbers;
    private Boolean allowMissingValues;
    private Boolean allowTrailingComma;
    private Boolean writeEnumsUseingIndex;
    private Boolean writeEnumsUsingToString;
    private Boolean wrapRootValue;
    private Boolean indentOutput;
    private Boolean wrapExceptions;
    private Boolean failOnEmptyBeans;
    private Boolean failOnSelfReferences;
    private Boolean failOnUnwrappedTypeIdentifiers;
    private Boolean closeCloseable;
    private Boolean flushAfterWriteValue;
    private Boolean writeDatesAsTimestamps;
    private Boolean writeDurationsAsTimestamps;
    private Boolean writeDateKeysAsTimestamps;
    private Boolean writeCharArraysAsJsonArrays;
    private Boolean writeSingleElemArraysUnwrapped;
    private Boolean orderMapEntriesByKeys;
    private Boolean useEqualityForObjectId;
    private Boolean writeDateTimestampsAsNanoseconds;
    private Boolean eagerserializerfetch;
    private Boolean requireSettersForGetters;
    private Boolean useStaticTyping;
    private Boolean sortPropertiesAlphabetically;
    private Boolean acceptCaseInsensitiveProperties;
    private Boolean useWrapperNameAsPropertyName;
    private Boolean useStdBeanNaming;
    private Boolean useAnnotations;
    private Boolean autoDetectCreators;
    private Boolean autoDetectFields;
    private Boolean autoDetectGetters;
    private Boolean autoDetectIsGetters;
    private Boolean autoDetectSetters;
    private Boolean useGettersAsSetters;
    private Boolean canOverrideAccessModifiers;
    private Boolean inferPropertyMutators;
    private Boolean allowFinalFieldsAsMutators;
    private Boolean defaultViewInclusion;
    private Boolean ignoreDuplicateModuleRegistrations;
    private Boolean writeBigdecimalAsPlain;
    private Boolean strictDuplicateDetection;
    private Boolean ignoreUnknown;
    private Boolean autoCloseTarget;
    private Boolean autoCloseJsonContent;
    private Boolean flushPassedToStream;
    private Boolean acceptEmptyArrayAsNullObject;
    private Boolean acceptEmptyStringAsNullObject;
    private Boolean acceptSingleValueAsArray;
    private Boolean adjustDatesToContextTimeZone;
    private Boolean eagerDeserializerFetch;
    private Boolean failOnIgnoredProperties;
    private Boolean failOnInvalidSubtype;
    private Boolean failOnNullForPrimitives;
    private Boolean failOnNumbersForEnums;
    private Boolean failOnReadingDupTreeKey;
    private Boolean failOnUnknownProperties;
    private Boolean failOnUnresolvedObjectIds;
    private Boolean readDateTimestampsAsNanoseconds;
    private Boolean readEnumsUsingToString;
    private Boolean readUnknownEnumValuesAsNull;
    private Boolean unwrapRootValue;
    private Boolean unwrapSingleValueArrays;
    private Boolean useBigDecimalForFloats;
    private Boolean useBigIntegerForInts;
    private Boolean userJavaArrayForJsonArray;

    public ObjectMapper create() {
        return this.configure();
    }

    private ObjectMapper configure() {
        JsonMapper.Builder mapperBuilder = JsonMapper.builder();
        this.configure(mapperBuilder, JsonWriteFeature.WRITE_NUMBERS_AS_STRINGS, this.writeNumbersAsStrings);
        this.configure(mapperBuilder, JsonWriteFeature.ESCAPE_NON_ASCII, this.escapeNonAscii);
        this.configure(mapperBuilder, JsonWriteFeature.QUOTE_FIELD_NAMES, this.quoteFieldNames);
        this.configure(mapperBuilder, JsonWriteFeature.WRITE_NAN_AS_STRINGS, this.writeNanAsStrings);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, this.allowBackslashEscapingAnyCharacter);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_JAVA_COMMENTS, this.allowJavaComments);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS, this.allowLeadingDecimalPointForNumbers);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS, this.allowLeadingZerosForNumbers);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_MISSING_VALUES, this.allowMissingValues);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS, this.allowNonNumericNumbers);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_SINGLE_QUOTES, this.allowSingleQuotes);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_TRAILING_COMMA, this.allowTrailingComma);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS, this.allowUnescapedControlChars);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES, this.allowUnquotedFieldNames);
        this.configure(mapperBuilder, JsonReadFeature.ALLOW_YAML_COMMENTS, this.allowYamlComments);
        this.configure(mapperBuilder, MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, this.acceptCaseInsensitiveProperties);
        this.configure(mapperBuilder, MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS, this.allowFinalFieldsAsMutators);
        this.configure(mapperBuilder, MapperFeature.AUTO_DETECT_CREATORS, this.autoDetectCreators);
        this.configure(mapperBuilder, MapperFeature.AUTO_DETECT_FIELDS, this.autoDetectFields);
        this.configure(mapperBuilder, MapperFeature.AUTO_DETECT_GETTERS, this.autoDetectGetters);
        this.configure(mapperBuilder, MapperFeature.AUTO_DETECT_IS_GETTERS, this.autoDetectIsGetters);
        this.configure(mapperBuilder, MapperFeature.AUTO_DETECT_SETTERS, this.autoDetectSetters);
        this.configure(mapperBuilder, MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, this.canOverrideAccessModifiers);
        this.configure(mapperBuilder, MapperFeature.DEFAULT_VIEW_INCLUSION, this.defaultViewInclusion);
        this.configure(mapperBuilder, MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS, this.ignoreDuplicateModuleRegistrations);
        this.configure(mapperBuilder, MapperFeature.INFER_PROPERTY_MUTATORS, this.inferPropertyMutators);
        this.configure(mapperBuilder, MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, this.requireSettersForGetters);
        this.configure(mapperBuilder, MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, this.sortPropertiesAlphabetically);
        this.configure(mapperBuilder, MapperFeature.USE_ANNOTATIONS, this.useAnnotations);
        this.configure(mapperBuilder, MapperFeature.USE_GETTERS_AS_SETTERS, this.useGettersAsSetters);
        this.configure(mapperBuilder, MapperFeature.USE_STATIC_TYPING, this.useStaticTyping);
        this.configure(mapperBuilder, MapperFeature.USE_STD_BEAN_NAMING, this.useStdBeanNaming);
        this.configure(mapperBuilder, MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME, this.useWrapperNameAsPropertyName);
        ObjectMapper mapper = mapperBuilder.build();
        this.configure(mapper);
        return mapper;
    }

    public void configure(ObjectMapper mapper) {
        if (mapper == null) {
            return;
        }
        if (Lang.isNotEmpty((String)this.dateFormat)) {
            mapper.setDateFormat((DateFormat)new SimpleDateFormat(this.dateFormat));
        }
        if (this.include != null) {
            mapper.setSerializationInclusion(this.include);
        }
        this.configure(mapper, SerializationFeature.WRITE_ENUMS_USING_INDEX, this.writeEnumsUseingIndex);
        this.configure(mapper, SerializationFeature.WRITE_ENUMS_USING_TO_STRING, this.writeEnumsUsingToString);
        this.configure(mapper, SerializationFeature.WRAP_ROOT_VALUE, this.wrapRootValue);
        this.configure(mapper, SerializationFeature.INDENT_OUTPUT, this.indentOutput);
        this.configure(mapper, SerializationFeature.WRAP_EXCEPTIONS, this.wrapExceptions);
        this.configure(mapper, SerializationFeature.FAIL_ON_EMPTY_BEANS, this.failOnEmptyBeans);
        this.configure(mapper, SerializationFeature.FAIL_ON_SELF_REFERENCES, this.failOnSelfReferences);
        this.configure(mapper, SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS, this.failOnUnwrappedTypeIdentifiers);
        this.configure(mapper, SerializationFeature.CLOSE_CLOSEABLE, this.closeCloseable);
        this.configure(mapper, SerializationFeature.FLUSH_AFTER_WRITE_VALUE, this.flushAfterWriteValue);
        this.configure(mapper, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, this.writeDatesAsTimestamps);
        this.configure(mapper, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, this.writeDurationsAsTimestamps);
        this.configure(mapper, SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, this.writeDateKeysAsTimestamps);
        this.configure(mapper, SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS, this.writeCharArraysAsJsonArrays);
        this.configure(mapper, SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, this.writeSingleElemArraysUnwrapped);
        this.configure(mapper, SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, this.orderMapEntriesByKeys);
        this.configure(mapper, SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID, this.useEqualityForObjectId);
        this.configure(mapper, SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, this.writeDateTimestampsAsNanoseconds);
        this.configure(mapper, SerializationFeature.EAGER_SERIALIZER_FETCH, this.eagerserializerfetch);
        this.configure(mapper, JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, this.writeBigdecimalAsPlain);
        this.configure(mapper, JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION, this.strictDuplicateDetection);
        this.configure(mapper, JsonGenerator.Feature.IGNORE_UNKNOWN, this.ignoreUnknown);
        this.configure(mapper, JsonGenerator.Feature.AUTO_CLOSE_TARGET, this.autoCloseTarget);
        this.configure(mapper, JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, this.autoCloseJsonContent);
        this.configure(mapper, JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, this.flushPassedToStream);
        this.configure(mapper, DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, this.acceptEmptyArrayAsNullObject);
        this.configure(mapper, DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, this.acceptEmptyStringAsNullObject);
        this.configure(mapper, DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, this.acceptSingleValueAsArray);
        this.configure(mapper, DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, this.adjustDatesToContextTimeZone);
        this.configure(mapper, DeserializationFeature.EAGER_DESERIALIZER_FETCH, this.eagerDeserializerFetch);
        this.configure(mapper, DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, this.failOnIgnoredProperties);
        this.configure(mapper, DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, this.failOnInvalidSubtype);
        this.configure(mapper, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, this.failOnNullForPrimitives);
        this.configure(mapper, DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, this.failOnNumbersForEnums);
        this.configure(mapper, DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, this.failOnReadingDupTreeKey);
        this.configure(mapper, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.failOnUnknownProperties);
        this.configure(mapper, DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, this.failOnUnresolvedObjectIds);
        this.configure(mapper, DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, this.readDateTimestampsAsNanoseconds);
        this.configure(mapper, DeserializationFeature.READ_ENUMS_USING_TO_STRING, this.readEnumsUsingToString);
        this.configure(mapper, DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, this.readUnknownEnumValuesAsNull);
        this.configure(mapper, DeserializationFeature.UNWRAP_ROOT_VALUE, this.unwrapRootValue);
        this.configure(mapper, DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, this.unwrapSingleValueArrays);
        this.configure(mapper, DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, this.useBigDecimalForFloats);
        this.configure(mapper, DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, this.useBigIntegerForInts);
        this.configure(mapper, DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, this.userJavaArrayForJsonArray);
        this.configure(mapper, DeserializationFeature.WRAP_EXCEPTIONS, this.wrapExceptions);
    }

    private void configure(JsonMapper.Builder builder, JsonReadFeature feature, Boolean state) {
        if (state != null) {
            builder.configure(feature, state.booleanValue());
        }
    }

    private void configure(JsonMapper.Builder builder, JsonWriteFeature feature, Boolean state) {
        if (state != null) {
            builder.configure(feature, state.booleanValue());
        }
    }

    private void configure(JsonMapper.Builder builder, MapperFeature feature, Boolean state) {
        if (state != null) {
            builder.configure(feature, state.booleanValue());
        }
    }

    private void configure(ObjectMapper mapper, SerializationFeature feature, Boolean state) {
        if (state != null) {
            mapper.configure(feature, state.booleanValue());
        }
    }

    private void configure(ObjectMapper mapper, JsonGenerator.Feature feature, Boolean state) {
        if (state != null) {
            mapper.configure(feature, state.booleanValue());
        }
    }

    private void configure(ObjectMapper mapper, DeserializationFeature feature, Boolean state) {
        if (state != null) {
            mapper.configure(feature, state.booleanValue());
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Boolean getWriteEnumsUseingIndex() {
        return this.writeEnumsUseingIndex;
    }

    public void setWriteEnumsUseingIndex(Boolean writeEnumsUseingIndex) {
        this.writeEnumsUseingIndex = writeEnumsUseingIndex;
    }

    public Boolean getWriteEnumsUsingToString() {
        return this.writeEnumsUsingToString;
    }

    public void setWriteEnumsUsingToString(Boolean writeEnumsUsingToString) {
        this.writeEnumsUsingToString = writeEnumsUsingToString;
    }

    public Boolean getWrapRootValue() {
        return this.wrapRootValue;
    }

    public void setWrapRootValue(Boolean wrapRootValue) {
        this.wrapRootValue = wrapRootValue;
    }

    public Boolean getIndentOutput() {
        return this.indentOutput;
    }

    public void setIndentOutput(Boolean indentOutput) {
        this.indentOutput = indentOutput;
    }

    public Boolean getWrapExceptions() {
        return this.wrapExceptions;
    }

    public void setWrapExceptions(Boolean wrapExceptions) {
        this.wrapExceptions = wrapExceptions;
    }

    public Boolean getFailOnEmptyBeans() {
        return this.failOnEmptyBeans;
    }

    public void setFailOnEmptyBeans(Boolean failOnEmptyBeans) {
        this.failOnEmptyBeans = failOnEmptyBeans;
    }

    public Boolean getFailOnSelfReferences() {
        return this.failOnSelfReferences;
    }

    public void setFailOnSelfReferences(Boolean failOnSelfReferences) {
        this.failOnSelfReferences = failOnSelfReferences;
    }

    public Boolean getFailOnUnwrappedTypeIdentifiers() {
        return this.failOnUnwrappedTypeIdentifiers;
    }

    public void setFailOnUnwrappedTypeIdentifiers(Boolean failOnUnwrappedTypeIdentifiers) {
        this.failOnUnwrappedTypeIdentifiers = failOnUnwrappedTypeIdentifiers;
    }

    public Boolean getCloseCloseable() {
        return this.closeCloseable;
    }

    public void setCloseCloseable(Boolean closeCloseable) {
        this.closeCloseable = closeCloseable;
    }

    public Boolean getFlushAfterWriteValue() {
        return this.flushAfterWriteValue;
    }

    public void setFlushAfterWriteValue(Boolean flushAfterWriteValue) {
        this.flushAfterWriteValue = flushAfterWriteValue;
    }

    public Boolean getWriteDatesAsTimestamps() {
        return this.writeDatesAsTimestamps;
    }

    public void setWriteDatesAsTimestamps(Boolean writeDatesAsTimestamps) {
        this.writeDatesAsTimestamps = writeDatesAsTimestamps;
    }

    public Boolean getWriteDurationsAsTimestamps() {
        return this.writeDurationsAsTimestamps;
    }

    public void setWriteDurationsAsTimestamps(Boolean writeDurationsAsTimestamps) {
        this.writeDurationsAsTimestamps = writeDurationsAsTimestamps;
    }

    public Boolean getWriteDateKeysAsTimestamps() {
        return this.writeDateKeysAsTimestamps;
    }

    public void setWriteDateKeysAsTimestamps(Boolean writeDateKeysAsTimestamps) {
        this.writeDateKeysAsTimestamps = writeDateKeysAsTimestamps;
    }

    public Boolean getWriteCharArraysAsJsonArrays() {
        return this.writeCharArraysAsJsonArrays;
    }

    public void setWriteCharArraysAsJsonArrays(Boolean writeCharArraysAsJsonArrays) {
        this.writeCharArraysAsJsonArrays = writeCharArraysAsJsonArrays;
    }

    public Boolean getWriteSingleElemArraysUnwrapped() {
        return this.writeSingleElemArraysUnwrapped;
    }

    public void setWriteSingleElemArraysUnwrapped(Boolean writeSingleElemArraysUnwrapped) {
        this.writeSingleElemArraysUnwrapped = writeSingleElemArraysUnwrapped;
    }

    public Boolean getOrderMapEntriesByKeys() {
        return this.orderMapEntriesByKeys;
    }

    public void setOrderMapEntriesByKeys(Boolean orderMapEntriesByKeys) {
        this.orderMapEntriesByKeys = orderMapEntriesByKeys;
    }

    public Boolean getUseEqualityForObjectId() {
        return this.useEqualityForObjectId;
    }

    public void setUseEqualityForObjectId(Boolean useEqualityForObjectId) {
        this.useEqualityForObjectId = useEqualityForObjectId;
    }

    public Boolean getWriteDateTimestampsAsNanoseconds() {
        return this.writeDateTimestampsAsNanoseconds;
    }

    public void setWriteDateTimestampsAsNanoseconds(Boolean writeDateTimestampsAsNanoseconds) {
        this.writeDateTimestampsAsNanoseconds = writeDateTimestampsAsNanoseconds;
    }

    public Boolean getEagerserializerfetch() {
        return this.eagerserializerfetch;
    }

    public void setEagerserializerfetch(Boolean eagerserializerfetch) {
        this.eagerserializerfetch = eagerserializerfetch;
    }

    public Boolean getRequireSettersForGetters() {
        return this.requireSettersForGetters;
    }

    public void setRequireSettersForGetters(Boolean requireSettersForGetters) {
        this.requireSettersForGetters = requireSettersForGetters;
    }

    public Boolean getUseStaticTyping() {
        return this.useStaticTyping;
    }

    public void setUseStaticTyping(Boolean useStaticTyping) {
        this.useStaticTyping = useStaticTyping;
    }

    public Boolean getSortPropertiesAlphabetically() {
        return this.sortPropertiesAlphabetically;
    }

    public void setSortPropertiesAlphabetically(Boolean sortPropertiesAlphabetically) {
        this.sortPropertiesAlphabetically = sortPropertiesAlphabetically;
    }

    public Boolean getAcceptCaseInsensitiveProperties() {
        return this.acceptCaseInsensitiveProperties;
    }

    public void setAcceptCaseInsensitiveProperties(Boolean acceptCaseInsensitiveProperties) {
        this.acceptCaseInsensitiveProperties = acceptCaseInsensitiveProperties;
    }

    public Boolean getUseWrapperNameAsPropertyName() {
        return this.useWrapperNameAsPropertyName;
    }

    public void setUseWrapperNameAsPropertyName(Boolean useWrapperNameAsPropertyName) {
        this.useWrapperNameAsPropertyName = useWrapperNameAsPropertyName;
    }

    public Boolean getUseStdBeanNaming() {
        return this.useStdBeanNaming;
    }

    public void setUseStdBeanNaming(Boolean useStdBeanNaming) {
        this.useStdBeanNaming = useStdBeanNaming;
    }

    public Boolean getUseAnnotations() {
        return this.useAnnotations;
    }

    public void setUseAnnotations(Boolean useAnnotations) {
        this.useAnnotations = useAnnotations;
    }

    public Boolean getAutoDetectCreators() {
        return this.autoDetectCreators;
    }

    public void setAutoDetectCreators(Boolean autoDetectCreators) {
        this.autoDetectCreators = autoDetectCreators;
    }

    public Boolean getAutoDetectFields() {
        return this.autoDetectFields;
    }

    public void setAutoDetectFields(Boolean autoDetectFields) {
        this.autoDetectFields = autoDetectFields;
    }

    public Boolean getAutoDetectGetters() {
        return this.autoDetectGetters;
    }

    public void setAutoDetectGetters(Boolean autoDetectGetters) {
        this.autoDetectGetters = autoDetectGetters;
    }

    public Boolean getAutoDetectIsGetters() {
        return this.autoDetectIsGetters;
    }

    public void setAutoDetectIsGetters(Boolean autoDetectIsGetters) {
        this.autoDetectIsGetters = autoDetectIsGetters;
    }

    public Boolean getAutoDetectSetters() {
        return this.autoDetectSetters;
    }

    public void setAutoDetectSetters(Boolean autoDetectSetters) {
        this.autoDetectSetters = autoDetectSetters;
    }

    public Boolean getUseGettersAsSetters() {
        return this.useGettersAsSetters;
    }

    public void setUseGettersAsSetters(Boolean useGettersAsSetters) {
        this.useGettersAsSetters = useGettersAsSetters;
    }

    public Boolean getCanOverrideAccessModifiers() {
        return this.canOverrideAccessModifiers;
    }

    public void setCanOverrideAccessModifiers(Boolean canOverrideAccessModifiers) {
        this.canOverrideAccessModifiers = canOverrideAccessModifiers;
    }

    public Boolean getInferPropertyMutators() {
        return this.inferPropertyMutators;
    }

    public void setInferPropertyMutators(Boolean inferPropertyMutators) {
        this.inferPropertyMutators = inferPropertyMutators;
    }

    public Boolean getAllowFinalFieldsAsMutators() {
        return this.allowFinalFieldsAsMutators;
    }

    public void setAllowFinalFieldsAsMutators(Boolean allowFinalFieldsAsMutators) {
        this.allowFinalFieldsAsMutators = allowFinalFieldsAsMutators;
    }

    public Boolean getDefaultViewInclusion() {
        return this.defaultViewInclusion;
    }

    public void setDefaultViewInclusion(Boolean defaultViewInclusion) {
        this.defaultViewInclusion = defaultViewInclusion;
    }

    public Boolean getIgnoreDuplicateModuleRegistrations() {
        return this.ignoreDuplicateModuleRegistrations;
    }

    public void setIgnoreDuplicateModuleRegistrations(Boolean ignoreDuplicateModuleRegistrations) {
        this.ignoreDuplicateModuleRegistrations = ignoreDuplicateModuleRegistrations;
    }

    public Boolean getWriteNumbersAsStrings() {
        return this.writeNumbersAsStrings;
    }

    public void setWriteNumbersAsStrings(Boolean writeNumbersAsStrings) {
        this.writeNumbersAsStrings = writeNumbersAsStrings;
    }

    public Boolean getWriteBigdecimalAsPlain() {
        return this.writeBigdecimalAsPlain;
    }

    public void setWriteBigdecimalAsPlain(Boolean writeBigdecimalAsPlain) {
        this.writeBigdecimalAsPlain = writeBigdecimalAsPlain;
    }

    public Boolean getEscapeNonAscii() {
        return this.escapeNonAscii;
    }

    public void setEscapeNonAscii(Boolean escapeNonAscii) {
        this.escapeNonAscii = escapeNonAscii;
    }

    public Boolean getStrictDuplicateDetection() {
        return this.strictDuplicateDetection;
    }

    public void setStrictDuplicateDetection(Boolean strictDuplicateDetection) {
        this.strictDuplicateDetection = strictDuplicateDetection;
    }

    public Boolean getIgnoreUnknown() {
        return this.ignoreUnknown;
    }

    public void setIgnoreUnknown(Boolean ignoreUnknown) {
        this.ignoreUnknown = ignoreUnknown;
    }

    public Boolean getAutoCloseTarget() {
        return this.autoCloseTarget;
    }

    public void setAutoCloseTarget(Boolean autoCloseTarget) {
        this.autoCloseTarget = autoCloseTarget;
    }

    public Boolean getAutoCloseJsonContent() {
        return this.autoCloseJsonContent;
    }

    public void setAutoCloseJsonContent(Boolean autoCloseJsonContent) {
        this.autoCloseJsonContent = autoCloseJsonContent;
    }

    public Boolean getQuoteFieldNames() {
        return this.quoteFieldNames;
    }

    public void setQuoteFieldNames(Boolean quoteFieldNames) {
        this.quoteFieldNames = quoteFieldNames;
    }

    public Boolean getWriteNanAsStrings() {
        return this.writeNanAsStrings;
    }

    public void setWriteNanAsStrings(Boolean writeNanAsStrings) {
        this.writeNanAsStrings = writeNanAsStrings;
    }

    public Boolean getAllowBackslashEscapingAnyCharacter() {
        return this.allowBackslashEscapingAnyCharacter;
    }

    public void setAllowBackslashEscapingAnyCharacter(Boolean allowBackslashEscapingAnyCharacter) {
        this.allowBackslashEscapingAnyCharacter = allowBackslashEscapingAnyCharacter;
    }

    @Deprecated
    public Boolean getQuoteNonNumericNumbers() {
        return this.getWriteNanAsStrings();
    }

    @Deprecated
    public void setQuoteNonNumericNumbers(Boolean quoteNonNumericNumbers) {
        this.setWriteNanAsStrings(quoteNonNumericNumbers);
    }

    public Boolean getFlushPassedToStream() {
        return this.flushPassedToStream;
    }

    public void setFlushPassedToStream(Boolean flushPassedToStream) {
        this.flushPassedToStream = flushPassedToStream;
    }

    public JsonInclude.Include getInclude() {
        return this.include;
    }

    public void setInclude(JsonInclude.Include include) {
        this.include = include;
    }

    public Boolean getAcceptEmptyArrayAsNullObject() {
        return this.acceptEmptyArrayAsNullObject;
    }

    public void setAcceptEmptyArrayAsNullObject(Boolean acceptEmptyArrayAsNullObject) {
        this.acceptEmptyArrayAsNullObject = acceptEmptyArrayAsNullObject;
    }

    public Boolean getAcceptEmptyStringAsNullObject() {
        return this.acceptEmptyStringAsNullObject;
    }

    public void setAcceptEmptyStringAsNullObject(Boolean acceptEmptyStringAsNullObject) {
        this.acceptEmptyStringAsNullObject = acceptEmptyStringAsNullObject;
    }

    public Boolean getAcceptSingleValueAsArray() {
        return this.acceptSingleValueAsArray;
    }

    public void setAcceptSingleValueAsArray(Boolean acceptSingleValueAsArray) {
        this.acceptSingleValueAsArray = acceptSingleValueAsArray;
    }

    public Boolean getAdjustDatesToContextTimeZone() {
        return this.adjustDatesToContextTimeZone;
    }

    public void setAdjustDatesToContextTimeZone(Boolean adjustDatesToContextTimeZone) {
        this.adjustDatesToContextTimeZone = adjustDatesToContextTimeZone;
    }

    public Boolean getEagerDeserializerFetch() {
        return this.eagerDeserializerFetch;
    }

    public void setEagerDeserializerFetch(Boolean eagerDeserializerFetch) {
        this.eagerDeserializerFetch = eagerDeserializerFetch;
    }

    public Boolean getFailOnIgnoredProperties() {
        return this.failOnIgnoredProperties;
    }

    public void setFailOnIgnoredProperties(Boolean failOnIgnoredProperties) {
        this.failOnIgnoredProperties = failOnIgnoredProperties;
    }

    public Boolean getFailOnInvalidSubtype() {
        return this.failOnInvalidSubtype;
    }

    public void setFailOnInvalidSubtype(Boolean failOnInvalidSubtype) {
        this.failOnInvalidSubtype = failOnInvalidSubtype;
    }

    public Boolean getFailOnNullForPrimitives() {
        return this.failOnNullForPrimitives;
    }

    public void setFailOnNullForPrimitives(Boolean failOnNullForPrimitives) {
        this.failOnNullForPrimitives = failOnNullForPrimitives;
    }

    public Boolean getFailOnNumbersForEnums() {
        return this.failOnNumbersForEnums;
    }

    public void setFailOnNumbersForEnums(Boolean failOnNumbersForEnums) {
        this.failOnNumbersForEnums = failOnNumbersForEnums;
    }

    public Boolean getFailOnReadingDupTreeKey() {
        return this.failOnReadingDupTreeKey;
    }

    public void setFailOnReadingDupTreeKey(Boolean failOnReadingDupTreeKey) {
        this.failOnReadingDupTreeKey = failOnReadingDupTreeKey;
    }

    public Boolean getFailOnUnknownProperties() {
        return this.failOnUnknownProperties;
    }

    public void setFailOnUnknownProperties(Boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public Boolean getFailOnUnresolvedObjectIds() {
        return this.failOnUnresolvedObjectIds;
    }

    public void setFailOnUnresolvedObjectIds(Boolean failOnUnresolvedObjectIds) {
        this.failOnUnresolvedObjectIds = failOnUnresolvedObjectIds;
    }

    public Boolean getReadDateTimestampsAsNanoseconds() {
        return this.readDateTimestampsAsNanoseconds;
    }

    public void setReadDateTimestampsAsNanoseconds(Boolean readDateTimestampsAsNanoseconds) {
        this.readDateTimestampsAsNanoseconds = readDateTimestampsAsNanoseconds;
    }

    public Boolean getReadEnumsUsingToString() {
        return this.readEnumsUsingToString;
    }

    public void setReadEnumsUsingToString(Boolean readEnumsUsingToString) {
        this.readEnumsUsingToString = readEnumsUsingToString;
    }

    public Boolean getReadUnknownEnumValuesAsNull() {
        return this.readUnknownEnumValuesAsNull;
    }

    public void setReadUnknownEnumValuesAsNull(Boolean readUnknownEnumValuesAsNull) {
        this.readUnknownEnumValuesAsNull = readUnknownEnumValuesAsNull;
    }

    public Boolean getUnwrapRootValue() {
        return this.unwrapRootValue;
    }

    public void setUnwrapRootValue(Boolean unwrapRootValue) {
        this.unwrapRootValue = unwrapRootValue;
    }

    public Boolean getUnwrapSingleValueArrays() {
        return this.unwrapSingleValueArrays;
    }

    public void setUnwrapSingleValueArrays(Boolean unwrapSingleValueArrays) {
        this.unwrapSingleValueArrays = unwrapSingleValueArrays;
    }

    public Boolean getUseBigDecimalForFloats() {
        return this.useBigDecimalForFloats;
    }

    public void setUseBigDecimalForFloats(Boolean useBigDecimalForFloats) {
        this.useBigDecimalForFloats = useBigDecimalForFloats;
    }

    public Boolean getUseBigIntegerForInts() {
        return this.useBigIntegerForInts;
    }

    public void setUseBigIntegerForInts(Boolean useBigIntegerForInts) {
        this.useBigIntegerForInts = useBigIntegerForInts;
    }

    public Boolean getUserJavaArrayForJsonArray() {
        return this.userJavaArrayForJsonArray;
    }

    public void setUserJavaArrayForJsonArray(Boolean userJavaArrayForJsonArray) {
        this.userJavaArrayForJsonArray = userJavaArrayForJsonArray;
    }

    public Boolean getAllowJavaComments() {
        return this.allowJavaComments;
    }

    public void setAllowJavaComments(Boolean allowJavaComments) {
        this.allowJavaComments = allowJavaComments;
    }

    public Boolean getAllowYamlComments() {
        return this.allowYamlComments;
    }

    public void setAllowYamlComments(Boolean allowYamlComments) {
        this.allowYamlComments = allowYamlComments;
    }

    public Boolean getAllowSingleQuotes() {
        return this.allowSingleQuotes;
    }

    public void setAllowSingleQuotes(Boolean allowSingleQuotes) {
        this.allowSingleQuotes = allowSingleQuotes;
    }

    public Boolean getAllowUnquotedFieldNames() {
        return this.allowUnquotedFieldNames;
    }

    public void setAllowUnquotedFieldNames(Boolean allowUnquotedFieldNames) {
        this.allowUnquotedFieldNames = allowUnquotedFieldNames;
    }

    public Boolean getAllowUnescapedControlChars() {
        return this.allowUnescapedControlChars;
    }

    public void setAllowUnescapedControlChars(Boolean allowUnescapedControlChars) {
        this.allowUnescapedControlChars = allowUnescapedControlChars;
    }

    public Boolean getAllowLeadingDecimalPointForNumbers() {
        return this.allowLeadingDecimalPointForNumbers;
    }

    public void setAllowLeadingDecimalPointForNumbers(Boolean allowLeadingDecimalPointForNumbers) {
        this.allowLeadingDecimalPointForNumbers = allowLeadingDecimalPointForNumbers;
    }

    public Boolean getAllowLeadingZerosForNumbers() {
        return this.allowLeadingZerosForNumbers;
    }

    public void setAllowLeadingZerosForNumbers(Boolean allowLeadingZerosForNumbers) {
        this.allowLeadingZerosForNumbers = allowLeadingZerosForNumbers;
    }

    public Boolean getAllowNonNumericNumbers() {
        return this.allowNonNumericNumbers;
    }

    public void setAllowNonNumericNumbers(Boolean allowNonNumericNumbers) {
        this.allowNonNumericNumbers = allowNonNumericNumbers;
    }

    public Boolean getAllowMissingValues() {
        return this.allowMissingValues;
    }

    public void setAllowMissingValues(Boolean allowMissingValues) {
        this.allowMissingValues = allowMissingValues;
    }

    public Boolean getAllowTrailingComma() {
        return this.allowTrailingComma;
    }

    public void setAllowTrailingComma(Boolean allowTrailingComma) {
        this.allowTrailingComma = allowTrailingComma;
    }
}

