/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.servlet.view.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class ObjectJacksonJsonView
extends MappingJackson2JsonView {
    private Object result;
    private int cacheExpires = -1;

    public ObjectJacksonJsonView() {
        this(null);
    }

    public ObjectJacksonJsonView(Object resultObject) {
        this.getObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        this.setResult(resultObject);
    }

    protected Object filterModel(Map<String, Object> model) {
        return this.result;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        this.setResponseContentType(request, response);
        response.setCharacterEncoding(this.getEncoding().getJavaName());
        if (this.cacheExpires > 0) {
            response.addHeader("Cache-Control", "max-age=" + this.cacheExpires);
        } else {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache, no-store, max-age=0");
            response.addDateHeader("Expires", 1L);
        }
    }

    public int getCacheExpires() {
        return this.cacheExpires;
    }

    public void setCacheExpires(int cacheExpires) {
        this.cacheExpires = cacheExpires;
    }
}

