/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.servlet.view;

import cn.featherfly.common.io.file.FileWrapper;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.web.WebException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.view.AbstractView;

public class ResourceView
extends AbstractView {
    private static final int DEFAULT_BUFFERSIZE = 10240;
    private Object result;
    private boolean allowCaching;
    private boolean delete;
    private String inputName;
    private String fileName;
    private String decodeCharset;
    private String encodeCharset = "ISO8859-1";
    private int bufferSize = 10240;
    private boolean downloadable;

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream is = null;
        String name = null;
        try {
            if (this.result instanceof File) {
                File file = (File)this.result;
                name = file.getName();
                is = new FileInputStream(file);
            } else if (this.result instanceof FileWrapper) {
                FileWrapper file = (FileWrapper)this.result;
                name = file.getFileName();
                is = new FileInputStream(file.getFile());
            } else if (this.result instanceof InputStream) {
                is = (InputStream)this.result;
            } else if (this.result instanceof byte[]) {
                is = new ByteArrayInputStream((byte[])this.result);
            }
        }
        catch (FileNotFoundException e) {
            throw new WebException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8def\u5f84\u4e0d\u5bf9", (Throwable)e);
        }
        if (is == null) {
            throw new WebException("\u6587\u4ef6\u7684\u5bf9\u8c61\u4e0d\u662fFile,FileWapper,byte[],InputStream\u7c7b\u578b");
        }
        this.download(request, response, is, this.result, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(HttpServletRequest request, HttpServletResponse response, InputStream is, Object downloadObj, String name) throws IOException {
        if (StringUtils.isBlank((CharSequence)this.getContentType())) {
            this.setContentType("application/octet-stream;charset=" + this.encodeCharset);
        }
        if (Strings.isNotBlank((String)this.fileName)) {
            name = this.fileName;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new WebException("\u4e0b\u8f7d\u6587\u4ef6\u7684\u6587\u4ef6\u672a\u6307\u5b9a\u4e0b\u8f7d\u6587\u4ef6\u540d");
        }
        if (!this.allowCaching) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        String encodeName = this.getEncodeName(name);
        if (request.getHeader("User-Agent").indexOf("MSIE 5.5") != -1) {
            response.setHeader("Content-Disposition", "filename=" + encodeName);
        } else {
            String contentDisposition = null;
            contentDisposition = this.downloadable ? "attachment;filename=" + encodeName : "inline;filename=" + encodeName;
            response.setHeader("Content-disposition", contentDisposition);
        }
        response.setHeader("Content-Type", this.getContentType());
        response.setContentType(this.getContentType());
        byte[] buffer = new byte[this.bufferSize];
        int length = 0;
        try {
            ServletOutputStream os = response.getOutputStream();
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
            os.flush();
            os.close();
        }
        finally {
            is.close();
            this.delete(downloadObj);
        }
    }

    protected boolean delete(Object obj) {
        if (this.delete && obj != null) {
            if (obj instanceof File) {
                File file = (File)obj;
                return file.delete();
            }
            if (obj instanceof FileWrapper) {
                FileWrapper file = (FileWrapper)obj;
                return file.getFile().delete();
            }
            throw new WebException("\u6587\u4ef6\u7684\u5bf9\u8c61\u4e0d\u662fFile,FileWapper\u7c7b\u578b\uff0c\u4e0d\u80fd\u81ea\u52a8\u5220\u9664\uff01");
        }
        return false;
    }

    protected String getEncodeName(String name) throws UnsupportedEncodingException {
        if (Lang.isEmpty((String)this.decodeCharset)) {
            return new String(name.getBytes(), this.encodeCharset);
        }
        return new String(name.getBytes(this.decodeCharset), this.encodeCharset);
    }

    public boolean isAllowCaching() {
        return this.allowCaching;
    }

    public void setAllowCaching(boolean allowCaching) {
        this.allowCaching = allowCaching;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public void setEncodeCharset(String encodeCharset) {
        this.encodeCharset = encodeCharset;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setDecodeCharset(String decodeCharset) {
        this.decodeCharset = decodeCharset;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public boolean isDownloadable() {
        return this.downloadable;
    }

    public void setDownloadable(boolean downloadable) {
        this.downloadable = downloadable;
    }
}

