/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.returnvaluehandler;

import cn.featherfly.common.policy.AllowPolicy;
import cn.featherfly.web.spring.servlet.view.Result;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ResponseBodyWrapHandler
implements HandlerMethodReturnValueHandler {
    private final HandlerMethodReturnValueHandler delegate;
    private AllowPolicy<Object> allowPolicy;
    private boolean onlyWrapNull;

    public ResponseBodyWrapHandler(HandlerMethodReturnValueHandler delegate) {
        this.delegate = delegate;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.delegate.supportsReturnType(returnType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (this.allowPolicy != null && !this.allowPolicy.isAllow(returnValue)) {
            this.delegate.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
        } else if (returnValue == null || !this.onlyWrapNull) {
            Result result = new Result();
            result.setData(returnValue);
            result.setCode("OK");
            this.delegate.handleReturnValue(result, returnType, mavContainer, webRequest);
        }
    }

    public AllowPolicy<Object> getAllowPolicy() {
        return this.allowPolicy;
    }

    public void setAllowPolicy(AllowPolicy<Object> allowPolicy) {
        this.allowPolicy = allowPolicy;
    }

    public boolean isOnlyWrapNull() {
        return this.onlyWrapNull;
    }

    public void setOnlyWrapNull(boolean onlyWrapNull) {
        this.onlyWrapNull = onlyWrapNull;
    }
}

