/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.method.support;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.web.pagination.PageFactory;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private PageFactory pageFactory;
    private ContentNegotiationManager contentNegotiationManager;
    private List<MediaType> ignoreMediaTypes = new ArrayList<MediaType>();

    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isParent(Page.class, (Class)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        AssertIllegalArgument.isNotNull((Object)this.pageFactory, (String)"pageFacotry\u4e0d\u80fd\u4e3a\u7a7a");
        List mediaTypes = this.contentNegotiationManager.resolveMediaTypes(webRequest);
        if (this.ignore(mediaTypes)) {
            return null;
        }
        return this.pageFactory.create((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
    }

    private boolean ignore(List<MediaType> mediaTypes) {
        for (MediaType mediaType : mediaTypes) {
            if (!this.ignore(mediaType)) continue;
            return true;
        }
        return false;
    }

    private boolean ignore(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        for (MediaType ignoreMediaType : this.ignoreMediaTypes) {
            if (!ignoreMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    public PageFactory getPageFactory() {
        return this.pageFactory;
    }

    public void setPageFactory(PageFactory pageFactory) {
        this.pageFactory = pageFactory;
    }

    public void setIgnoreMediaTypes(List<String> ignoreMediaTypes) {
        if (Lang.isNotEmpty(ignoreMediaTypes)) {
            for (String ignoreMediaType : ignoreMediaTypes) {
                MediaType mediaType = MediaType.valueOf((String)ignoreMediaType);
                this.ignoreMediaTypes.add(mediaType);
            }
        }
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }
}

