/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.messageconverter;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.web.spring.interceptor.RequestHolderInterceptor;
import cn.featherfly.web.spring.messageconverter.AttachHttpMessageConverter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.jxls.common.Context;
import org.jxls.util.JxlsHelper;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class JxlsHttpMessageConverter
extends AttachHttpMessageConverter {
    private boolean autoHeight = true;

    public JxlsHttpMessageConverter() {
        this(null);
    }

    public JxlsHttpMessageConverter(ClassLoader classLoader) {
        super(classLoader);
        this.extNames = new String[]{"xlsx", "xls"};
        this.setSupportedMediaTypes(Arrays.asList(new MediaType("application", "excel"), new MediaType("application", "*+excel"), new MediaType("application", "jxls")));
    }

    protected void writeInternal(Object result, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        HttpServletRequest request = RequestHolderInterceptor.getHttpServletRequest();
        String fileName = this.getFileName(request);
        fileName = new String(fileName.getBytes(), "ISO-8859-1");
        outputMessage.getHeaders().set("Content-Disposition", "attachment;filename=" + fileName);
        outputMessage.getHeaders().setContentType(this.getDefaultContentType());
        Context context = new Context();
        String rp = this.getResolverPath();
        if (Lang.isNotEmpty((String)rp)) {
            Object source = this.getDataFromResult(result, request);
            context.putVar(rp, source);
        } else {
            context.putVar("result", result);
        }
        InputStream is = this.getTemplate(request);
        JxlsHelper.getInstance().processTemplate(is, outputMessage.getBody(), context);
    }

    public boolean isAutoHeight() {
        return this.autoHeight;
    }

    public void setAutoHeight(boolean autoHeight) {
        this.autoHeight = autoHeight;
    }
}

