/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.messageconverter;

import cn.featherfly.data.office.excel.ExcelDataMapper;
import cn.featherfly.data.office.excel.ExcelDataSource;
import cn.featherfly.data.office.excel.ExcelSwaggerModelMapper;
import cn.featherfly.web.spring.interceptor.RequestHolderInterceptor;
import cn.featherfly.web.spring.messageconverter.AttachHttpMessageConverter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class ExcelHttpMessageConverter
extends AttachHttpMessageConverter {
    private ExcelDataMapper<?> mapper = new ExcelSwaggerModelMapper();

    public ExcelHttpMessageConverter() {
        this(null);
    }

    public ExcelHttpMessageConverter(ClassLoader classLoader) {
        super(classLoader);
        this.extNames = new String[]{"xlsx", "xls"};
        this.resolverPath = "data.content";
        this.setSupportedMediaTypes(Arrays.asList(new MediaType("application", "excel"), new MediaType("application", "*+excel")));
    }

    protected void writeInternal(Object result, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        HttpServletRequest request = RequestHolderInterceptor.getHttpServletRequest();
        String fileName = this.getFileName(request);
        fileName = new String(fileName.getBytes(), "ISO-8859-1");
        outputMessage.getHeaders().set("Content-Disposition", "attachment;filename=" + fileName);
        outputMessage.getHeaders().setContentType(this.getDefaultContentType());
        Object data = this.getDataFromResult(result, request);
        if (data != null) {
            ArrayList<Object> datas;
            if (data instanceof Collection) {
                datas = (ArrayList<Object>)data;
            } else {
                datas = new ArrayList<Object>();
                datas.add(data);
            }
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                ExcelDataSource source = new ExcelDataSource((Workbook)workbook, this.mapper);
                source.addDataSet().addRecords(datas);
                source.save(outputMessage.getBody());
            }
        }
    }

    public ExcelDataMapper<?> getMapper() {
        return this.mapper;
    }

    public void setMapper(ExcelDataMapper<?> mapper) {
        this.mapper = mapper;
    }
}

