/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.messageconverter;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.UriUtils;
import cn.featherfly.web.WebException;
import cn.featherfly.web.servlet.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;

public abstract class AttachHttpMessageConverter
extends AbstractGenericHttpMessageConverter<Object> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected String[] extNames;
    protected boolean allowNameParam;
    private boolean allowNameAsLastUri;
    protected String nameParamKey = "fileName";
    protected String resolverPath = "data";
    protected boolean allowResolverPath;
    protected String resolverPathKey = "resolverPath";
    protected boolean allowIgnorePagination;
    protected String ignorePaginationKey = "ignorePagination";
    protected String templatePathKey = "template";
    protected String templateBasePath = "";
    private ClassLoader classLoader;

    protected AttachHttpMessageConverter() {
        this(null);
    }

    protected AttachHttpMessageConverter(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    protected boolean matchExtName(String name) {
        for (String extName : this.extNames) {
            if (!name.endsWith(extName)) continue;
            return true;
        }
        return false;
    }

    protected InputStream getTemplate(HttpServletRequest request) {
        boolean match;
        Object p;
        Object templatePath = null;
        if (Lang.isNotEmpty((String)this.templatePathKey) && Lang.isEmpty((String)(templatePath = request.getParameter(this.templatePathKey))) && (p = request.getAttribute(this.templatePathKey)) != null) {
            templatePath = p.toString();
        }
        if (Lang.isEmpty(templatePath)) {
            templatePath = ServletUtils.getRequestURI((HttpServletRequest)request);
        }
        if (!(match = this.matchExtName((String)(templatePath = UriUtils.linkUri((String)this.templateBasePath, (String)templatePath))))) {
            templatePath = (String)templatePath + "." + this.extNames[0];
        }
        this.logger.debug("TemplatePath -> {}", templatePath);
        InputStream is = this.classLoader.getResourceAsStream((String)templatePath);
        if (is == null) {
            String fileName = StringUtils.substringAfterLast((String)templatePath, (String)"/");
            this.logger.debug("\u672a\u627e\u5230\u8def\u5f84{}\u5bf9\u5e94\u7684\u6a21\u677f\uff0c\u4f7f\u7528{}\u518d\u67e5\u627e", templatePath, (Object)fileName);
            is = this.classLoader.getResourceAsStream(UriUtils.linkUri((String)this.templateBasePath, (String)fileName));
            if (Lang.isEmpty((Object)is)) {
                throw new WebException("\u672a\u627e\u5230[" + fileName + "]\u5bf9\u5e94\u7684\u6a21\u677f");
            }
        }
        return is;
    }

    protected String getFileName(HttpServletRequest request) {
        boolean match;
        if (request == null) {
            return System.currentTimeMillis() + "." + this.extNames[0];
        }
        Object fileName = null;
        if (this.allowNameParam) {
            fileName = request.getParameter(this.nameParamKey);
        }
        if (this.allowNameAsLastUri && StringUtils.isBlank((CharSequence)fileName)) {
            String uri = ServletUtils.getRequestURI((HttpServletRequest)request);
            fileName = StringUtils.substringAfterLast((String)uri, (String)"/");
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = "" + System.currentTimeMillis();
        }
        if (!(match = this.matchExtName((String)fileName))) {
            fileName = (String)fileName + "." + this.extNames[0];
        }
        return fileName;
    }

    protected Object getDataFromResult(Object result, HttpServletRequest request) {
        String rp = this.getResolverPath(request);
        if (result != null) {
            if (Strings.isNotBlank((String)rp)) {
                return BeanUtils.getProperty((Object)result, (String)rp);
            }
            return result;
        }
        return null;
    }

    protected String getResolverPath(HttpServletRequest request) {
        if (request == null) {
            return this.resolverPath;
        }
        String rp = null;
        if (this.allowResolverPath) {
            rp = request.getParameter(this.resolverPathKey);
        }
        if (StringUtils.isBlank(rp)) {
            rp = this.resolverPath;
        }
        this.logger.debug("ResolverPath -> {}", (Object)rp);
        return rp;
    }

    protected MediaType getDefaultContentType() throws IOException {
        List mediaTypes = this.getSupportedMediaTypes();
        return !mediaTypes.isEmpty() ? (MediaType)mediaTypes.get(0) : null;
    }

    public boolean isAllowNameParam() {
        return this.allowNameParam;
    }

    public void setAllowNameParam(boolean allowNameParam) {
        this.allowNameParam = allowNameParam;
    }

    public String getNameParamKey() {
        return this.nameParamKey;
    }

    public void setNameParamKey(String nameParamKey) {
        this.nameParamKey = nameParamKey;
    }

    public String[] getExtNames() {
        return this.extNames;
    }

    public void setExtNames(String[] extNames) {
        this.extNames = extNames;
    }

    public String getResolverPath() {
        return this.resolverPath;
    }

    public void setResolverPath(String resolverPath) {
        this.resolverPath = resolverPath;
    }

    public boolean isAllowResolverPath() {
        return this.allowResolverPath;
    }

    public void setAllowResolverPath(boolean allowResolverPath) {
        this.allowResolverPath = allowResolverPath;
    }

    public String getResolverPathKey() {
        return this.resolverPathKey;
    }

    public void setResolverPathKey(String resolverPathKey) {
        this.resolverPathKey = resolverPathKey;
    }

    public boolean isAllowNameAsLastUri() {
        return this.allowNameAsLastUri;
    }

    public void setAllowNameAsLastUri(boolean allowNameAsLastUri) {
        this.allowNameAsLastUri = allowNameAsLastUri;
    }

    public boolean isAllowIgnorePagination() {
        return this.allowIgnorePagination;
    }

    public void setAllowIgnorePagination(boolean allowIgnorePagination) {
        this.allowIgnorePagination = allowIgnorePagination;
    }

    public String getIgnorePaginationKey() {
        return this.ignorePaginationKey;
    }

    public void setIgnorePaginationKey(String ignorePaginationKey) {
        this.ignorePaginationKey = ignorePaginationKey;
    }

    public String getTemplatePathKey() {
        return this.templatePathKey;
    }

    public void setTemplatePathKey(String templatePathKey) {
        this.templatePathKey = templatePathKey;
    }

    public String getTemplateBasePath() {
        return this.templateBasePath;
    }

    public void setTemplateBasePath(String templateBasePath) {
        this.templateBasePath = templateBasePath;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

