/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.interceptor;

import cn.featherfly.web.spring.annotation.HttpCache;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HttpCacheInterceptor
implements AsyncHandlerInterceptor {
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        HandlerMethod invokedMethod = (HandlerMethod)handler;
        HttpCache httpCache = invokedMethod.getMethod().getAnnotation(HttpCache.class);
        if (httpCache != null) {
            long expireTime = httpCache.expire();
            if (expireTime > 0L) {
                response.addHeader("Cache-Control", "max-age=" + expireTime);
            } else {
                response.addHeader("Pragma", "no-cache");
                response.addHeader("Cache-Control", "no-cache, no-store, max-age=0");
                response.addDateHeader("Expires", 1L);
            }
        }
    }
}

