/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

@Component
public class CrosHostInterceptor
implements AsyncHandlerInterceptor {
    private String allowOriginStr;
    private String allowHeadersStr;
    private String allowMethodsStr;
    private List<String> allowOrigin;
    private List<String> allowHeaders;
    private List<String> allowMethods;
    private int maxAge = 3600;

    public CrosHostInterceptor() {
        ArrayList<String> _allowOrigin = new ArrayList<String>();
        _allowOrigin.add("*");
        this.setAllowOrigin(_allowOrigin);
        ArrayList<String> _allowHeaders = new ArrayList<String>();
        _allowHeaders.add("X-Requested-With");
        _allowHeaders.add("content-type");
        _allowHeaders.add("token");
        this.setAllowHeaders(_allowHeaders);
        ArrayList<String> _allowMethods = new ArrayList<String>();
        _allowMethods.add("GET");
        _allowMethods.add("HEAD");
        _allowMethods.add("POST");
        _allowMethods.add("PUT");
        _allowMethods.add("DELETE");
        _allowMethods.add("TRACE");
        _allowMethods.add("OPTIONS");
        _allowMethods.add("PATCH");
        this.setAllowMethods(_allowMethods);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        response.setHeader("Access-Control-Allow-Origin", this.allowOriginStr);
        response.setHeader("Access-Control-Allow-Headers", this.allowHeadersStr);
        response.setHeader("Access-Control-Allow-Methods", this.allowMethodsStr);
        response.setHeader("Access-Control-Max-Age", "" + this.maxAge);
        return true;
    }

    private String toString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String string : list) {
            sb.append(string).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public List<String> getAllowOrigin() {
        return this.allowOrigin;
    }

    public void setAllowOrigin(List<String> allowOrigin) {
        this.allowOrigin = allowOrigin;
        this.allowOriginStr = this.toString(allowOrigin);
    }

    public List<String> getAllowHeaders() {
        return this.allowHeaders;
    }

    public void setAllowHeaders(List<String> allowHeaders) {
        this.allowHeaders = allowHeaders;
        this.allowHeadersStr = this.toString(allowHeaders);
    }

    public List<String> getAllowMethods() {
        return this.allowMethods;
    }

    public void setAllowMethods(List<String> allowMethods) {
        this.allowMethods = allowMethods;
        this.allowMethodsStr = this.toString(allowMethods);
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }
}

