/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.handlerexception;

import cn.featherfly.common.exception.ExceptionCode;
import cn.featherfly.common.exception.ExceptionCodeException;
import cn.featherfly.common.lang.LogUtils;
import cn.featherfly.web.spring.servlet.view.Result;
import cn.featherfly.web.spring.servlet.view.json.ObjectJacksonJsonView;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.PriorityOrdered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ExceptionHandlerExceptionResolver
implements HandlerExceptionResolver,
PriorityOrdered {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandlerExceptionResolver.class);
    private Integer httpStatus = 400;
    private Map<Class<?>, Integer> exceptionHttpStatusMap = new HashMap();
    private int order = 1;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        Integer status;
        ExceptionCode exceptionCode;
        LogUtils.error((Exception)ex, (Logger)LOG);
        Result result = new Result();
        result.setCode("ERROR");
        response.setStatus(this.httpStatus.intValue());
        String code = null;
        if (ex instanceof ExceptionCodeException && (exceptionCode = ((ExceptionCodeException)ex).getExceptionCode()) != null) {
            code = exceptionCode.getCode();
            result.setCode(exceptionCode.getCode());
        }
        if ((status = this.exceptionHttpStatusMap.get(ex.getClass())) != null) {
            response.setStatus(status.intValue());
        }
        result.setMessage(ex.getLocalizedMessage());
        LOG.error(code, (Throwable)ex);
        return new ModelAndView((View)new ObjectJacksonJsonView((Object)result));
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }

    public Map<Class<?>, Integer> getExceptionHttpStatusMap() {
        return this.exceptionHttpStatusMap;
    }

    public void setExceptionHttpStatusMap(Map<Class<?>, Integer> exceptionHttpStatusMap) {
        this.exceptionHttpStatusMap = exceptionHttpStatusMap;
    }
}

