/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.web.spring.handlerexception;

import cn.featherfly.web.spring.servlet.view.Result;
import cn.featherfly.web.spring.servlet.view.json.ObjectJacksonJsonView;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.core.PriorityOrdered;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public abstract class BindResultHandlerExceptionResolver
implements HandlerExceptionResolver,
PriorityOrdered {
    private Integer httpStatus = 400;
    private int order = 0;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        BindingResult bindingResult = this.getBindingResult(ex);
        if (bindingResult != null) {
            Result result = new Result();
            StringBuilder messages = new StringBuilder();
            if (bindingResult.hasErrors()) {
                result.setCode("ERROR");
            }
            if (bindingResult.hasGlobalErrors()) {
                for (ObjectError oe : bindingResult.getGlobalErrors()) {
                    messages.append(oe.getDefaultMessage()).append("\uff0c");
                }
            }
            if (bindingResult.hasFieldErrors()) {
                for (FieldError fr : bindingResult.getFieldErrors()) {
                    messages.append(fr.getDefaultMessage()).append("\uff0c");
                }
            }
            if (messages.length() > 0) {
                messages.deleteCharAt(messages.length() - 1);
            }
            result.setMessage(messages.toString());
            response.setStatus(this.httpStatus.intValue());
            return new ModelAndView((View)new ObjectJacksonJsonView((Object)result));
        }
        return null;
    }

    protected abstract BindingResult getBindingResult(Exception var1);

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }
}

