/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.component.sorm.operate;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.builder.ConditionBuilder;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.component.sorm.SimpleORMException;
import cn.featherfly.component.sorm.operate.AbstractQueryOperate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class QueryOperate<T>
extends AbstractQueryOperate<T> {
    public QueryOperate(Class<T> type, JdbcTemplate jdbcTemplate) {
        super(type, jdbcTemplate);
    }

    public QueryOperate(Class<T> type, JdbcTemplate jdbcTemplate, String dataBase) {
        super(type, jdbcTemplate, dataBase);
    }

    public T unique(ConditionBuilder conditionBuilder) {
        conditionBuilder.setBuildWithWhere(false);
        return this.unique(conditionBuilder.build(), CollectionUtils.toArray((Collection)conditionBuilder.getParams(), Object.class));
    }

    public T unique(String condition, Object ... params) {
        List<T> list = this.list(condition, params);
        if (LangUtils.isNotEmpty(list)) {
            if (list.size() > 1) {
                throw new JdbcException("invoke unique method, but multy object find");
            }
            return list.get(0);
        }
        return null;
    }

    public List<T> list(ConditionBuilder conditionBuilder) {
        conditionBuilder.setBuildWithWhere(false);
        return this.list(conditionBuilder.build(), CollectionUtils.toArray((Collection)conditionBuilder.getParams(), Object.class));
    }

    public List<T> list(final String condition, final Object ... params) {
        if (LangUtils.isEmpty((String)condition)) {
            throw new SimpleORMException("#list.condition.null");
        }
        return (List)this.jdbcTemplate.execute(new ConnectionCallback<List<T>>(){

            public List<T> doInConnection(Connection conn) throws SQLException, DataAccessException {
                String executeSql = QueryOperate.this.getSql(condition);
                QueryOperate.this.logger.debug("execute sql: {}", (Object)executeSql);
                PreparedStatement prep = conn.prepareStatement(executeSql);
                JdbcUtils.setParameters((PreparedStatement)prep, (Object[])params);
                ResultSet res = prep.executeQuery();
                ArrayList<Object> list = new ArrayList<Object>();
                int index = 0;
                Object t = null;
                while (res.next()) {
                    t = QueryOperate.this.mapRow(res, index);
                    ++index;
                    list.add(t);
                }
                prep.close();
                conn.close();
                return list;
            }
        });
    }

    @Override
    protected String initCondition() {
        return "";
    }

    public String getSql(String condition) {
        condition = LangUtils.isNotEmpty((String)condition) ? " where " + condition : "";
        return this.sql + condition;
    }

    public String getSql(ConditionBuilder builder) {
        builder.setBuildWithWhere(true);
        return this.sql + " " + builder.build();
    }
}

