/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.jdbc.rwds;

import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.jdbc.rwds.ReadWriteDataSourceDecision;
import cn.featherfly.jdbc.rwds.ReadWriteDataSourceTransactionException;
import java.util.ArrayList;
import java.util.Collection;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.CompositeTransactionAttributeSource;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class ReadWriteDataSourceProcessor
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteDataSourceProcessor.class);
    private boolean forceChoiceReadWhenWrite;
    private TransactionAttributeSource transactionAttributeSource;

    public void setForceChoiceReadWhenWrite(boolean forceChoiceReadWhenWrite) {
        this.forceChoiceReadWhenWrite = forceChoiceReadWhenWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object determineReadOrWriteDB(ProceedingJoinPoint pjp) throws Throwable {
        if (pjp.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
            RuleBasedTransactionAttribute txAttr = (RuleBasedTransactionAttribute)this.transactionAttributeSource.getTransactionAttribute(methodSignature.getMethod(), pjp.getSignature().getDeclaringType());
            if (txAttr == null) {
                throw new ReadWriteDataSourceTransactionException("there is no transaction for " + methodSignature.getMethod());
            }
            LOG.debug("{} with TransactionAttribute {}", (Object)methodSignature.getMethod().toString(), (Object)txAttr.toString());
            boolean choice = false;
            if (ReadWriteDataSourceDecision.isChoiceNone()) {
                choice = true;
            }
            if (this.isChoiceReadDB(txAttr)) {
                ReadWriteDataSourceDecision.markRead();
                LOG.debug("read transaction process for {}", (Object)methodSignature.getMethod().toString());
            } else {
                ReadWriteDataSourceDecision.markWrite();
                LOG.debug("write transaction process for {}", (Object)methodSignature.getMethod().toString());
            }
            try {
                Object object = pjp.proceed();
                return object;
            }
            finally {
                if (choice) {
                    ReadWriteDataSourceDecision.reset();
                }
            }
        }
        throw new ReadWriteDataSourceTransactionException("! pjp.getSignature() instanceof MethodSignature");
    }

    private boolean isChoiceReadDB(RuleBasedTransactionAttribute txAttr) {
        LOG.debug("ReadWriteDataSourceDecision.isChoiceNone {}", (Object)ReadWriteDataSourceDecision.isChoiceNone());
        if (ReadWriteDataSourceDecision.isChoiceNone()) {
            return txAttr.isReadOnly();
        }
        if (this.forceChoiceReadWhenWrite) {
            if (txAttr.isReadOnly()) {
                txAttr.setPropagationBehavior(Propagation.NOT_SUPPORTED.value());
            }
            return true;
        }
        if (ReadWriteDataSourceDecision.isChoiceWrite()) {
            txAttr.setPropagationBehavior(Propagation.SUPPORTS.value());
            return false;
        }
        return txAttr.isReadOnly();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection ts = applicationContext.getBeansOfType(TransactionAspectSupport.class).values();
        ArrayList<TransactionAttributeSource> tas = new ArrayList<TransactionAttributeSource>();
        for (TransactionAspectSupport t : ts) {
            tas.add(t.getTransactionAttributeSource());
        }
        if (tas.size() == 1) {
            this.transactionAttributeSource = (TransactionAttributeSource)tas.get(0);
        } else if (ts.size() > 1) {
            this.transactionAttributeSource = new CompositeTransactionAttributeSource((TransactionAttributeSource[])CollectionUtils.toArray(tas, TransactionAttributeSource.class));
        }
    }
}

