/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.permission.web.login;

import cn.featherfly.permission.core.PermissionActor;
import cn.featherfly.permission.login.LoginInfo;
import cn.featherfly.permission.web.login.WebActorLoginStorage;
import cn.featherfly.permission.web.login.WebLoginInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractWebActorLoginStorage<W extends WebLoginInfo<A>, A extends PermissionActor>
implements WebActorLoginStorage<W, A> {
    private Map<String, W> webLoginInfos = new HashMap<String, W>();

    protected abstract W createLoginInfo();

    @Override
    public void store(String key, A actor) {
        W webLoginInfo = this.createLoginInfo();
        ((LoginInfo)webLoginInfo).setActor(actor);
        ((LoginInfo)webLoginInfo).setLoginTime(new Date());
        ((WebLoginInfo)webLoginInfo).setSession(key);
        this.webLoginInfos.put(key, webLoginInfo);
    }

    @Override
    public void remove(A actor) {
        if (actor != null) {
            this.webLoginInfos.remove(((WebLoginInfo)this.getLoginInfo((PermissionActor)actor)).getSession());
        }
    }

    @Override
    public void remove(String key) {
        this.webLoginInfos.remove(key);
    }

    @Override
    public W getLoginInfo(String key) {
        return (W)((WebLoginInfo)this.webLoginInfos.get(key));
    }

    @Override
    public W getLoginInfo(A actor) {
        if (actor != null) {
            for (WebLoginInfo webLoginInfo : this.webLoginInfos.values()) {
                if (!webLoginInfo.getActor().getId().equals(actor.getId())) continue;
                return (W)webLoginInfo;
            }
        }
        return null;
    }

    @Override
    public List<A> getLoginActors() {
        ArrayList actors = new ArrayList();
        for (WebLoginInfo loginActor : this.webLoginInfos.values()) {
            Object a = loginActor.getActor();
            actors.add(a);
        }
        return actors;
    }

    @Override
    public List<W> getLoginInfos() {
        return new ArrayList<W>(this.webLoginInfos.values());
    }

    @Override
    public boolean containsKey(String key) {
        return this.webLoginInfos.containsKey(key);
    }
}

