/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.permission.web.authentication;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.permission.authentication.AuthenticationException;
import cn.featherfly.permission.core.PermissionActor;
import cn.featherfly.permission.web.authentication.WebAuthenticator;
import javax.servlet.http.HttpServletRequest;

public class ValidCodeAuthenticator<A extends PermissionActor>
implements WebAuthenticator<A> {
    public static final String VALID_CODE_KEY = "validCode";
    private boolean caseSensitive;

    @Override
    public void authenticate(A actor, HttpServletRequest request) {
        Object valid;
        String validCode = request.getParameter(VALID_CODE_KEY);
        if (LangUtils.isEmpty((String)validCode) && (valid = request.getAttribute(VALID_CODE_KEY)) != null) {
            validCode = valid.toString();
        }
        Object storedValidCode = request.getSession().getAttribute(VALID_CODE_KEY);
        if (LangUtils.isNotEmpty((String)validCode) && storedValidCode != null && (this.caseSensitive ? validCode.equals(storedValidCode.toString()) : validCode.equalsIgnoreCase(storedValidCode.toString()))) {
            return;
        }
        throw new AuthenticationException("@permission#validateCode.error");
    }

    public static void setVerifyValidCode(HttpServletRequest request, String validCode) {
        request.setAttribute(VALID_CODE_KEY, (Object)validCode);
    }

    public static void setGeneratedValidCode(HttpServletRequest request, String validCode) {
        request.getSession().setAttribute(VALID_CODE_KEY, (Object)validCode);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

