/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.permission.web.login.springmvc.interceptor;

import cn.featherfly.common.i18n.ResourceBundleUtils;
import cn.featherfly.permission.web.login.WebApplicationLoginManager;
import cn.featherfly.web.servlet.ServletUtils;
import cn.featherfly.web.spring.servlet.view.Result;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthorizedInterceptor
implements HandlerInterceptor {
    private WebApplicationLoginManager<?> applicationLoginManager;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = new ObjectMapper();
    private Collection<String> excludes = new HashSet<String>();
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private String charset = "UTF-8";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Result result = new Result();
        String uri = ServletUtils.getRequestURI((HttpServletRequest)request);
        this.logger.debug("uri -> {}", (Object)uri);
        boolean exclude = false;
        for (String excludeUri : this.excludes) {
            if (!this.antPathMatcher.match(excludeUri, uri)) continue;
            exclude = true;
            break;
        }
        if (!exclude && !this.applicationLoginManager.isLogin(request)) {
            result.setMessage(ResourceBundleUtils.getString((String)"@permission#session.invalidation"));
            request.getSession().invalidate();
            if (request.getHeader("Accept").contains("application/json")) {
                response.setStatus(401);
                this.render(response, result);
            } else {
                response.sendError(401, result.getMessage());
            }
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    private void render(HttpServletResponse response, Object result) {
        try {
            response.setContentType("application/json;charset=" + this.charset);
            response.setCharacterEncoding(this.charset);
            this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writerFor(result.getClass()).writeValue((OutputStream)response.getOutputStream(), result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setExcludes(Collection<String> excludes) {
        this.excludes = excludes;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setApplicationLoginManager(WebApplicationLoginManager<?> applicationLoginManager) {
        this.applicationLoginManager = applicationLoginManager;
    }
}

