/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.permission.web.login;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.permission.authentication.AuthenticationException;
import cn.featherfly.permission.core.PermissionActor;
import cn.featherfly.permission.exception.PermissionException;
import cn.featherfly.permission.login.LoginEvent;
import cn.featherfly.permission.login.LoginInfo;
import cn.featherfly.permission.login.LoginListener;
import cn.featherfly.permission.web.authentication.WebAuthenticator;
import cn.featherfly.permission.web.login.WebActorLoginStorage;
import cn.featherfly.permission.web.login.WebApplicationLoginManager;
import cn.featherfly.permission.web.login.WebLoginInfo;
import cn.featherfly.web.servlet.ServletUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationLoginManagerImpl<W extends WebLoginInfo>
implements WebApplicationLoginManager<W> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplicationLoginManagerImpl.class);
    private WebActorLoginStorage<W> webActorLoginStorage;
    private List<LoginListener<W>> loginListeners = new ArrayList<LoginListener<W>>();
    private boolean sameOnline;
    private List<WebAuthenticator> authenticators = new ArrayList<WebAuthenticator>();

    @Override
    public <A extends PermissionActor> void login(A actor, HttpServletRequest request) {
        LOGGER.debug("\u767b\u5f55: {}", (Object)actor.getDescp());
        if (LangUtils.isEmpty(this.authenticators)) {
            throw new PermissionException("@permission#authenticators.null");
        }
        String key = request.getSession().getId();
        W info = this.webActorLoginStorage.getLoginInfo(key);
        if (info != null && !((LoginInfo)info).getActor().getId().equals(actor.getId())) {
            throw new AuthenticationException("@permission#session.with.account");
        }
        for (WebAuthenticator authenticator : this.authenticators) {
            authenticator.authenticate(actor, request);
        }
        if (!this.isSameOnline() && this.isLogin(actor)) {
            LOGGER.debug("{}\u5df2\u7ecf\u767b\u5f55\uff0c\u6ce8\u9500\u4e4b\u524d\u7684\u767b\u5f55\u4fe1\u606f\u5e76\u91cd\u65b0\u767b\u5f55", (Object)actor.getDescp());
            this.logout(actor);
        }
        this.webActorLoginStorage.store(key, actor);
        W webLoginInfo = this.getLoginInfo((A)request);
        ((WebLoginInfo)webLoginInfo).setIp(ServletUtils.getIpAddr((HttpServletRequest)request));
        LoginEvent<W> loginEvent = new LoginEvent<W>();
        loginEvent.setLoginInfo(webLoginInfo);
        for (LoginListener<W> loginListener : this.loginListeners) {
            loginListener.onLogin(loginEvent);
        }
    }

    @Override
    public boolean isLogin(HttpServletRequest request) {
        return this.webActorLoginStorage.containsKey(request.getSession().getId());
    }

    @Override
    public <A extends PermissionActor> boolean isLogin(A actor) {
        return this.getLoginInfo((PermissionActor)actor) != null;
    }

    @Override
    public void logout(HttpServletRequest request) {
        this.logout(request.getSession());
    }

    @Override
    public void logout(HttpSession session) {
        W webLoginInfo;
        if (LOGGER.isDebugEnabled() && (webLoginInfo = this.getLoginInfo((A)((PermissionActor)session))) != null) {
            LOGGER.debug("\u6ce8\u9500\uff1a{}", (Object)((LoginInfo)webLoginInfo).getActor().getDescp());
        }
        this.webActorLoginStorage.remove(session.getId());
    }

    @Override
    public <A extends PermissionActor> void logout(A actor) {
        if (actor != null) {
            LOGGER.debug("\u6ce8\u9500\uff1a{}", (Object)actor.getDescp());
            this.webActorLoginStorage.remove(actor);
        }
    }

    @Override
    public <A extends PermissionActor> List<A> getLoginActors() {
        return this.webActorLoginStorage.getLoginActors();
    }

    @Override
    public W getLoginInfo(HttpServletRequest request) {
        return this.getLoginInfo((A)((PermissionActor)request.getSession()));
    }

    @Override
    public W getLoginInfo(HttpSession session) {
        return this.webActorLoginStorage.getLoginInfo(session.getId());
    }

    @Override
    public <A extends PermissionActor> W getLoginInfo(A actor) {
        return this.webActorLoginStorage.getLoginInfo(actor);
    }

    @Override
    public void addLoginListener(LoginListener<W> loginListener) {
        this.loginListeners.add(loginListener);
    }

    public boolean isSameOnline() {
        return this.sameOnline;
    }

    public void setSameOnline(boolean sameOnline) {
        this.sameOnline = sameOnline;
    }

    public void setWebActorLoginStorage(WebActorLoginStorage<W> webActorLoginStorage) {
        this.webActorLoginStorage = webActorLoginStorage;
    }

    public void setLoginListeners(List<LoginListener<W>> loginListeners) {
        this.loginListeners = loginListeners;
    }

    public List<WebAuthenticator> getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(List<WebAuthenticator> authenticators) {
        this.authenticators = authenticators;
    }
}

