/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.data.office.word;

import cn.featherfly.data.office.OfficeDataSource;
import cn.featherfly.data.office.word.WordDataMapper;
import cn.featherfly.data.office.word.WordDataSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;

public class WordDataSource<R>
implements OfficeDataSource<WordDataSet<R>, R> {
    private List<WordDataSet<R>> dataSets;
    private XWPFDocument document;
    private WordDataMapper<R> mapper;

    public WordDataSource(XWPFDocument document, WordDataMapper<R> mapper) {
        if (document == null) {
            throw new RuntimeException("document \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.document = document;
        this.mapper = mapper;
        this.dataSets = new ArrayList<WordDataSet<R>>(document.getTables().size());
        for (XWPFTable table : document.getTables()) {
            this.dataSets.add(new WordDataSet<R>(table, this.dataSets.size(), mapper));
        }
    }

    public WordDataSource(InputStream is, WordDataMapper<R> mapper) throws IOException {
        this(new XWPFDocument(is), mapper);
        is.close();
    }

    public WordDataSource(File file, WordDataMapper<R> mapper) throws IOException {
        this(new FileInputStream(file), mapper);
    }

    @Override
    public WordDataSet<R> getDataSet(int index) {
        return this.dataSets.get(index);
    }

    @Override
    public Collection<WordDataSet<R>> getDataSets() {
        return this.dataSets;
    }

    @Override
    public int getDataSetsNumber() {
        return this.dataSets.size();
    }

    @Override
    public WordDataSet<R> addDataSet() {
        XWPFTable table = this.document.createTable();
        WordDataSet<R> wordDataSet = new WordDataSet<R>(table, this.dataSets.size() + 1, this.mapper);
        this.dataSets.add(wordDataSet);
        return wordDataSet;
    }

    @Override
    public void save(OutputStream outputStream) throws IOException {
        this.document.write(outputStream);
    }
}

