/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.data.office.word;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.data.core.DataSet;
import cn.featherfly.data.office.word.WordDataMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class WordDataSet<R>
implements DataSet<R> {
    private List<R> records = new ArrayList<R>();
    private int index = -1;
    private XWPFTable table;
    private WordDataMapper<R> mapper;

    public WordDataSet(XWPFTable table, int index, WordDataMapper<R> mapper) {
        this.index = index;
        this.table = table;
        this.mapper = mapper;
        int rowNum = 1;
        for (XWPFTableRow row : table.getRows()) {
            this.records.add(mapper.mapRecord(row, rowNum));
            ++rowNum;
        }
    }

    @Override
    public Collection<R> getDataRecords() {
        return this.records;
    }

    @Override
    public R getDataRecord(int index) {
        return this.records.get(index);
    }

    @Override
    public int getDataRecordsNumber() {
        return this.records.size();
    }

    @Override
    public <D extends DataSet<R>> D addRecord(R record) {
        int rowNum = this.table.getNumberOfRows();
        XWPFTableRow row = this.table.createRow();
        this.mapper.fillData(row, record, ++rowNum);
        this.records.add(record);
        return (D)this;
    }

    @Override
    public <D extends DataSet<R>> D addRecord(R ... records) {
        if (LangUtils.isNotEmpty((Object[])records)) {
            for (R record : records) {
                this.addRecord(record);
            }
        }
        return (D)this;
    }

    @Override
    public <D extends DataSet<R>> D addRecords(Collection<R> records) {
        if (LangUtils.isNotEmpty(records)) {
            for (R record : records) {
                this.addRecord(record);
            }
        }
        return (D)this;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

