/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.data.office.excel;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.matcher.BeanPropertyAnnotationMatcher;
import cn.featherfly.common.bean.matcher.BeanPropertyMatcher;
import cn.featherfly.data.office.excel.ExcelDataMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class ExcelSwaggerModelMapper<R>
extends ExcelDataMapper<R> {
    private boolean insertTitleRow = true;

    public ExcelSwaggerModelMapper() {
        this(true);
    }

    public ExcelSwaggerModelMapper(boolean insertTitleRow) {
        this.insertTitleRow = insertTitleRow;
    }

    @Override
    public R mapRecord(Row row, int rowNum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillData(Row row, R record, int rowNum) {
        if (record != null) {
            BeanDescriptor beanDescriptor = BeanDescriptor.getBeanDescriptor(record.getClass());
            Collection<BeanProperty<?>> beanProperties = this.getApiModelBeanProperties(beanDescriptor);
            int index = 0;
            if (this.insertTitleRow && rowNum == 0) {
                for (BeanProperty<?> beanProperty : beanProperties) {
                    ApiModelProperty apiModelProperty = (ApiModelProperty)beanProperty.getAnnotation(ApiModelProperty.class);
                    Cell cell = row.createCell(index);
                    this.setCellValue(apiModelProperty.value(), cell);
                    ++index;
                }
                row = row.getSheet().createRow(rowNum + 1);
                index = 0;
            }
            for (BeanProperty<?> beanProperty : beanProperties) {
                Cell cell = row.createCell(index);
                Object object = beanProperty.getValue(record);
                this.setCellValue(object, cell);
                ++index;
            }
        }
    }

    public boolean isInsertTitleRow() {
        return this.insertTitleRow;
    }

    public void setInsertTitleRow(boolean insertTitleRow) {
        this.insertTitleRow = insertTitleRow;
    }

    private Collection<BeanProperty<?>> getApiModelBeanProperties(BeanDescriptor<?> beanDescriptor) {
        return beanDescriptor.findBeanPropertys((BeanPropertyMatcher)new BeanPropertyAnnotationMatcher(new Class[]{ApiModelProperty.class}));
    }
}

