/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.data.office.excel;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.NumberUtils;
import cn.featherfly.common.lang.reflect.GenericClass;
import cn.featherfly.data.office.excel.ExcelDataMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;

public class ExcelObjectMapper<R>
extends ExcelDataMapper<R> {
    private Map<Integer, String> columnPropertyNameMap;
    private List<String> titles;
    private Class<R> type;

    public ExcelObjectMapper(Class<R> type) {
        this(type, new HashMap<Integer, String>(), new ArrayList<String>());
    }

    public ExcelObjectMapper(Class<R> type, Map<Integer, String> columnPropertyNameMap) {
        this(type, columnPropertyNameMap, new ArrayList<String>());
    }

    public ExcelObjectMapper(Class<R> type, Map<Integer, String> columnPropertyNameMap, List<String> titles) {
        this.type = type;
        this.columnPropertyNameMap = columnPropertyNameMap;
        this.titles = titles;
    }

    @Override
    public R mapRecord(Row row, int rowNum) {
        Object record = ClassUtils.newInstance(this.type);
        if (row != null) {
            FormulaEvaluator evaluator = this.getFormulaEvaluator(row.getSheet().getWorkbook());
            BeanDescriptor bd = BeanDescriptor.getBeanDescriptor(this.type);
            for (Map.Entry<Integer, String> columnPropertyName : this.columnPropertyNameMap.entrySet()) {
                Cell cell = row.getCell(columnPropertyName.getKey().intValue());
                if (cell != null) {
                    Object value = this.getCellValue(cell, evaluator);
                    Class propertyType = bd.getBeanProperty(columnPropertyName.getValue()).getType();
                    if (value.getClass() != propertyType) {
                        value = value instanceof Number ? NumberUtils.convert((Number)((Number)value), (Class)propertyType) : this.conversion.toObject(value.toString(), (GenericType)new GenericClass(propertyType));
                    }
                    BeanUtils.setProperty((Object)record, (String)columnPropertyName.getValue(), (Object)value);
                    continue;
                }
                this.logger.debug("cell of column[{}] is null", (Object)columnPropertyName.getKey());
            }
        }
        return (R)record;
    }

    @Override
    public void fillData(Row row, R record, int rowNum) {
        if (LangUtils.isNotEmpty(this.titles) && rowNum == 0) {
            for (int i = 0; i < this.titles.size(); ++i) {
                String title = this.titles.get(i);
                Cell cell = row.createCell(i);
                this.setCellValue(title, cell);
            }
            row = row.getSheet().createRow(rowNum + 1);
        }
        if (record != null) {
            for (Map.Entry<Integer, String> columnPropertyName : this.columnPropertyNameMap.entrySet()) {
                Object value = BeanUtils.getProperty(record, (String)columnPropertyName.getValue());
                Cell cell = row.createCell(columnPropertyName.getKey().intValue());
                this.setCellValue(value, cell);
            }
        }
    }

    public Map<Integer, String> getColumnPropertyNameMap() {
        return this.columnPropertyNameMap;
    }

    public void setColumnPropertyNameMap(Map<Integer, String> columnPropertyNameMap) {
        this.columnPropertyNameMap = columnPropertyNameMap;
    }

    public Class<R> getType() {
        return this.type;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public void setTitles(List<String> titles) {
        this.titles = titles;
    }
}

