/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.data.office.excel;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.data.core.DataSet;
import cn.featherfly.data.office.excel.ExcelDataMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelDataSet<R>
implements DataSet<R> {
    private List<R> records = new ArrayList<R>();
    private int index = -1;
    private Sheet sheet;
    private ExcelDataMapper<R> mapper;

    public ExcelDataSet(Sheet sheet, FormulaEvaluator evaluator, ExcelDataMapper<R> mapper) {
        if (sheet == null) {
            throw new IllegalArgumentException("sheet \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (evaluator == null) {
            throw new IllegalArgumentException("evaluator \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.index = sheet.getWorkbook().getSheetIndex(sheet);
        this.sheet = sheet;
        this.mapper = mapper;
        this.init(sheet, evaluator, mapper);
    }

    private void init(Sheet sheet, FormulaEvaluator evaluator, ExcelDataMapper<R> mapper) {
        int rowNum = sheet.getLastRowNum() + 1;
        for (int rIndex = 0; rIndex < rowNum; ++rIndex) {
            Row row = sheet.getRow(rIndex);
            if (row == null) continue;
            this.records.add(mapper.mapRecord(row, rowNum));
        }
    }

    @Override
    public Collection<R> getDataRecords() {
        return this.records;
    }

    @Override
    public R getDataRecord(int index) {
        return this.records.get(index);
    }

    @Override
    public int getDataRecordsNumber() {
        return this.records.size();
    }

    @Override
    public <D extends DataSet<R>> D addRecord(R record) {
        Row row = null;
        if (this.records.isEmpty()) {
            row = this.sheet.getRow(this.sheet.getLastRowNum());
            if (row == null) {
                row = this.sheet.createRow(this.sheet.getLastRowNum());
            }
        } else {
            row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
        }
        this.mapper.fillData(row, record, row.getRowNum());
        this.records.add(record);
        return (D)this;
    }

    @Override
    public <D extends DataSet<R>> D addRecord(R ... records) {
        if (LangUtils.isNotEmpty((Object[])records)) {
            for (R record : records) {
                this.addRecord(record);
            }
        }
        return (D)this;
    }

    @Override
    public <D extends DataSet<R>> D addRecords(Collection<R> records) {
        if (LangUtils.isNotEmpty(records)) {
            for (R record : records) {
                this.addRecord(record);
            }
        }
        return (D)this;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

