/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.data.office.excel;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.reflect.GenericClass;
import cn.featherfly.conversion.core.Conversion;
import cn.featherfly.conversion.core.ConversionPolicys;
import cn.featherfly.conversion.core.TypeConversion;
import cn.featherfly.data.core.DataMapper;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFFormulaEvaluator;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelDataMapper<R>
implements DataMapper<R, Row> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Conversion conversion = new TypeConversion(ConversionPolicys.getBasicConversionPolicy());

    protected void setCellValue(Object value, Cell cell) {
        if (value != null) {
            cell.setCellValue(this.conversion.toString(value, (GenericType)new GenericClass(value.getClass())));
        }
    }

    protected Object getCellValue(Cell cell, FormulaEvaluator evaluator) {
        if (cell == null) {
            return null;
        }
        Object value = null;
        block0 : switch (cell.getCellType()) {
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case BLANK: {
                break;
            }
            case ERROR: {
                break;
            }
            case FORMULA: {
                CellValue cellValue = evaluator.evaluate(cell);
                switch (cellValue.getCellType()) {
                    case STRING: {
                        value = cellValue.getStringValue();
                        break block0;
                    }
                    case NUMERIC: {
                        value = cellValue.getNumberValue();
                        break block0;
                    }
                    case BOOLEAN: {
                        value = cellValue.getBooleanValue();
                        break block0;
                    }
                    case BLANK: {
                        break block0;
                    }
                    case ERROR: {
                        break block0;
                    }
                    case FORMULA: {
                        break block0;
                    }
                }
                break;
            }
        }
        return value;
    }

    protected FormulaEvaluator getFormulaEvaluator(Workbook workbook) {
        Object evaluator = null;
        evaluator = workbook instanceof XSSFWorkbook ? new XSSFFormulaEvaluator((XSSFWorkbook)workbook) : (workbook instanceof SXSSFWorkbook ? new SXSSFFormulaEvaluator((SXSSFWorkbook)workbook) : new HSSFFormulaEvaluator((HSSFWorkbook)workbook));
        return evaluator;
    }
}

