/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.data.office.excel;

import cn.featherfly.data.office.OfficeDataSource;
import cn.featherfly.data.office.excel.ExcelDataMapper;
import cn.featherfly.data.office.excel.ExcelDataSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.POIXMLException;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFFormulaEvaluator;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelDataSource<R>
implements OfficeDataSource<ExcelDataSet<R>, R> {
    private List<ExcelDataSet<R>> dataSets;
    private Workbook workbook;
    private ExcelDataMapper<R> mapper;
    private FormulaEvaluator evaluator;

    public ExcelDataSource(Workbook workbook, ExcelDataMapper<R> mapper) {
        if (workbook == null) {
            throw new IllegalArgumentException("workbook \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.workbook = workbook;
        this.mapper = mapper;
        this.init(workbook, mapper);
    }

    public ExcelDataSource(File file, ExcelDataMapper<R> mapper) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("file \u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.mapper = mapper;
        try {
            this.workbook = new XSSFWorkbook((InputStream)new FileInputStream(file));
            this.init(this.workbook, mapper);
        }
        catch (POIXMLException e) {
            this.workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
            this.init(this.workbook, mapper);
        }
    }

    private void init(Workbook workbook, ExcelDataMapper<R> mapper) {
        int sheetNumber = workbook.getNumberOfSheets();
        this.dataSets = new ArrayList<ExcelDataSet<R>>(sheetNumber);
        this.evaluator = workbook instanceof XSSFWorkbook ? new XSSFFormulaEvaluator((XSSFWorkbook)workbook) : (workbook instanceof SXSSFWorkbook ? new SXSSFFormulaEvaluator((SXSSFWorkbook)workbook) : new HSSFFormulaEvaluator((HSSFWorkbook)workbook));
        for (int i = 0; i < sheetNumber; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            this.dataSets.add(new ExcelDataSet<R>(sheet, this.evaluator, mapper));
        }
    }

    @Override
    public ExcelDataSet<R> getDataSet(int index) {
        return this.dataSets.get(index);
    }

    @Override
    public Collection<ExcelDataSet<R>> getDataSets() {
        return this.dataSets;
    }

    @Override
    public int getDataSetsNumber() {
        return this.dataSets.size();
    }

    @Override
    public ExcelDataSet<R> addDataSet() {
        Sheet sheet = this.workbook.createSheet();
        ExcelDataSet<R> dataSet = new ExcelDataSet<R>(sheet, this.evaluator, this.mapper);
        this.dataSets.add(dataSet);
        return dataSet;
    }

    @Override
    public void save(OutputStream outputStream) throws IOException {
        this.workbook.write(outputStream);
    }
}

