/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.data.office.excel;

import cn.featherfly.data.core.DataRecord;
import cn.featherfly.data.impl.SimpleDataRecord;
import cn.featherfly.data.office.excel.ExcelDataMapper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelDataRecordMapper
extends ExcelDataMapper<DataRecord> {
    @Override
    public DataRecord mapRecord(Row row, int rowNum) {
        Workbook workbook = row.getSheet().getWorkbook();
        FormulaEvaluator evaluator = this.getFormulaEvaluator(workbook);
        return this.craeteRecord(row, evaluator);
    }

    @Override
    public void fillData(Row row, DataRecord record, int rowNum) {
        for (int i = 0; i < record.getValuesNumber(); ++i) {
            Object value = record.get(i);
            this.setCellValue(value, row.createCell(i));
        }
    }

    private DataRecord craeteRecord(Row row, FormulaEvaluator evaluator) {
        SimpleDataRecord record = null;
        if (row != null) {
            record = new SimpleDataRecord();
            for (int cIndex = 0; cIndex < row.getLastCellNum(); ++cIndex) {
                Cell cell = row.getCell(cIndex);
                Object value = this.getCellValue(cell, evaluator);
                record.add(cIndex + "", value);
            }
        }
        return record;
    }
}

