/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.data.office.excel;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.reflect.GenericClass;
import cn.featherfly.conversion.core.Conversion;
import cn.featherfly.conversion.core.ConversionPolicysJdk8;
import cn.featherfly.conversion.core.TypeConversion;
import cn.featherfly.data.core.DataMapper;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFFormulaEvaluator;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelDataMapper<R>
implements DataMapper<R, Row> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Conversion conversion = new TypeConversion(ConversionPolicysJdk8.getBasicConversionPolicy());

    protected void setCellValue(Object value, Cell cell) {
        if (value != null) {
            cell.setCellValue(this.conversion.toString(value, (GenericType)new GenericClass(value.getClass())));
        }
    }

    protected Object getCellValue(Cell cell, FormulaEvaluator evaluator) {
        if (cell == null) {
            return null;
        }
        Object value = null;
        block0 : switch (cell.getCellType()) {
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = cell.getNumericCellValue();
                break;
            }
            case 4: {
                value = cell.getBooleanCellValue();
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                CellValue cellValue = evaluator.evaluate(cell);
                switch (cellValue.getCellType()) {
                    case 1: {
                        value = cellValue.getStringValue();
                        break block0;
                    }
                    case 0: {
                        value = cellValue.getNumberValue();
                        break block0;
                    }
                    case 4: {
                        value = cellValue.getBooleanValue();
                        break block0;
                    }
                    case 3: {
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                }
                break;
            }
        }
        return value;
    }

    protected FormulaEvaluator getFormulaEvaluator(Workbook workbook) {
        Object evaluator = null;
        evaluator = workbook instanceof XSSFWorkbook ? new XSSFFormulaEvaluator((XSSFWorkbook)workbook) : (workbook instanceof SXSSFWorkbook ? new SXSSFFormulaEvaluator((SXSSFWorkbook)workbook) : new HSSFFormulaEvaluator((HSSFWorkbook)workbook));
        return evaluator;
    }
}

