/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string.format;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.LogUtils;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.conversion.ConversionException;
import cn.featherfly.conversion.string.basic.DateConvertor;
import cn.featherfly.conversion.string.format.FormatConvertor;
import cn.featherfly.conversion.string.format.FormatType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;

public class DateFormatConvertor
extends FormatConvertor<Date> {
    public DateFormatConvertor() {
        super(new DateConvertor());
    }

    @Override
    protected String formatToString(Date value, FormatType<Date> genericType) {
        if (value != null && genericType != null && Strings.isNotBlank((String)genericType.getFormat())) {
            SimpleDateFormat sdf = new SimpleDateFormat(genericType.getFormat());
            return sdf.format(value);
        }
        return null;
    }

    @Override
    protected Date formatToObject(String value, FormatType<Date> genericType) {
        if (value != null && genericType != null && Lang.isNotEmpty(genericType.getFormats())) {
            List<String> formats = genericType.getFormats();
            for (String format : formats) {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                try {
                    return sdf.parse(value);
                }
                catch (ParseException e) {
                    LogUtils.debug((Exception)e, (Logger)this.logger);
                }
            }
            throw new ConversionException("#convert_failed_with_type", new Object[]{value, formats, this.getSourceType().getName()});
        }
        return null;
    }
}

