/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string.bp;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.conversion.annotation.Format;
import cn.featherfly.conversion.string.bp.BeanPropertyConvertor;
import cn.featherfly.conversion.string.format.FormatConvertor;
import cn.featherfly.conversion.string.format.FormatType;

public class BeanPropertyFormatConvertor<T>
extends BeanPropertyConvertor<T> {
    private FormatConvertor<T> convertor;

    public BeanPropertyFormatConvertor(FormatConvertor<T> convertor) {
        this.convertor = convertor;
    }

    @Override
    protected String doToString(T value, BeanProperty<T> beanProperty) {
        FormatType formatType = new FormatType(this.getSourceType());
        Format format = (Format)beanProperty.getAnnotation(Format.class);
        if (beanProperty != null && format != null) {
            formatType.setFormat(format.format());
            formatType.setFormats(ArrayUtils.toList((Object[])format.formats()));
        }
        return this.convertor.sourceToTarget(value, formatType);
    }

    @Override
    protected T doToObject(String value, BeanProperty<T> beanProperty) {
        FormatType formatType = new FormatType(this.getSourceType());
        Format format = (Format)beanProperty.getAnnotation(Format.class);
        if (beanProperty != null && format != null) {
            formatType.setFormat(format.format());
            formatType.setFormats(ArrayUtils.toList((Object[])format.formats()));
        }
        return (T)this.convertor.targetToSource(value, formatType);
    }

    public FormatConvertor<T> getConvertor() {
        return this.convertor;
    }
}

